<?php
include_once includes('config.php');
header('Content-Type: application/json');

// Authenticate
if (!isset($_SESSION['user']['id'])) {
    die(json_encode(['error' => 'Unauthorized']));
}

$user_id = $_SESSION['user']['id'];
$orderNumber = $_POST['orderNumber'];
if (empty($orderNumber)) {
    die(json_encode(['error' => 'Order number required']));
}

function getUsername($orderNumber, $user_id, $conn) {
    $stmt = $conn->prepare("SELECT username FROM hosting_orders WHERE user_id = ? AND order_number = ?");
    $stmt->bind_param("is", $user_id, $orderNumber);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc()['username'];
}
$username = getUsername($orderNumber, $user_id, $conn);

if (empty($username)) {
    die(json_encode(['error' => 'Username required']));
}

// Get account summary
$query = "https://$whm_host:2087/json-api/accountsummary?api.version=1&user=$username";

$curl = curl_init();
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
$header = ["Authorization: Basic " . base64_encode("$whm_user:$whm_pass")];
curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
curl_setopt($curl, CURLOPT_URL, $query);
$result = curl_exec($curl);

if ($result === false) {
    die(json_encode(['error' => curl_error($curl)]));
}

$data = json_decode($result, true);

// Check if we got valid data
if (!isset($data['data']['acct'][0])) {
    die(json_encode(['error' => 'Invalid account data']));
}

$account = $data['data']['acct'][0];

// Convert disk usage to GB
$diskused = 0;
if (isset($account['diskused'])) {
    $diskused = convertToGB($account['diskused']);
}

// Prepare response
$response = [
    'disk_used' => $diskused,
    'disk_limit' => $account['disklimit'] === 'unlimited' ? 'unlimited' : convertToGB($account['disklimit']),
    'bandwidth_used' => 0, // This API doesn't provide bandwidth in this endpoint
    'bandwidth_limit' => 'unlimited', // This API doesn't provide bandwidth in this endpoint
    'raw_data' => $account // For debugging
];

echo json_encode($response);

// Helper function to convert values like "1159M" to GB
function convertToGB($value) {
    if ($value === 'unlimited') return 'unlimited';

    // If it's already a number, assume bytes
    if (is_numeric($value)) {
        return round($value / (1024 * 1024 * 1024), 2);
    }

    // Handle values with units (like "1159M")
    $unit = strtoupper(substr($value, -1));
    $number = substr($value, 0, -1);

    if (!is_numeric($number)) {
        return 0;
    }

    switch ($unit) {
        case 'K':
            return round($number / (1024 * 1024), 2);
        case 'M':
            return round($number / 1024, 2);
        case 'G':
            return round($number, 2);
        case 'T':
            return round($number * 1024, 2);
        default:
            return round($number / (1024 * 1024 * 1024), 2);
    }
}
?>