<?php
include_once includes('config.php');
header('Content-Type: application/json');

if (!isset($_SESSION['user']['id'])) {
    die(json_encode(['error' => 'Unauthorized']));
}

$user_id = $_SESSION['user']['id'];
$days = isset($_POST['days']) ? (int)$_POST['days'] : 7;

// Get analytics data from database
$stmt = $conn->prepare("
    SELECT date, visitors, pageviews, bandwidth 
    FROM hosting_analytics 
    WHERE user_id = ? AND date >= DATE_SUB(CURDATE(), INTERVAL ? DAY)
    ORDER BY date ASC
");
$stmt->bind_param("ii", $user_id, $days);
$stmt->execute();
$result = $stmt->get_result();

$labels = [];
$visitors = [];
$pageviews = [];
$bandwidth = [];

while ($row = $result->fetch_assoc()) {
    $labels[] = date('M j', strtotime($row['date']));
    $visitors[] = $row['visitors'];
    $pageviews[] = $row['pageviews'];
    $bandwidth[] = $row['bandwidth'];
}

// Calculate totals
$totalVisitors = array_sum($visitors);
$totalPageviews = array_sum($pageviews);
$totalBandwidth = array_sum($bandwidth);

echo json_encode([
    'labels' => $labels,
    'visitors' => $visitors,
    'pageviews' => $pageviews,
    'bandwidth' => $bandwidth,
    'totals' => [
        'visitors' => $totalVisitors,
        'pageviews' => $totalPageviews,
        'bandwidth' => round($totalBandwidth, 1)
    ]
]);
?>