<?php
include_once includes('config.php');
header('Content-Type: application/json');

if (!isset($_SESSION['user']['id'])) {
    die(json_encode(['error' => 'Unauthorized']));
}

$user_id = $_SESSION['user']['id'];

// Get recent activity from database
$stmt = $conn->prepare("
    SELECT action, description, created_at 
    FROM hosting_activity 
    WHERE user_id = ? 
    ORDER BY created_at DESC 
    LIMIT 5
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$activities = [];
while ($row = $result->fetch_assoc()) {
    $activities[] = [
        'title' => getFriendlyActionName($row['action']),
        'description' => $row['description'],
        'time' => time_elapsed_string($row['created_at']),
        'icon' => getActivityIcon($row['action'])
    ];
}

echo json_encode($activities);

function getFriendlyActionName($action) {
    $actions = [
        'cpanel_login' => 'Logged into cPanel',
        'file_upload' => 'File Uploaded',
        'db_create' => 'Database Created',
        'email_create' => 'Email Account Created',
        'backup' => 'Backup Created',
        'setting_update' => 'Settings Updated'
    ];
    return $actions[$action] ?? $action;
}

function time_elapsed_string($datetime, $full = false) {
    $now = new DateTime;
    $ago = new DateTime($datetime);
    $diff = $now->diff($ago);

    $string = [
        'y' => 'year',
        'm' => 'month',
        'd' => 'day',
        'h' => 'hour',
        'i' => 'minute',
        's' => 'second',
    ];

    foreach ($string as $k => &$v) {
        if ($diff->$k) {
            $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
        } else {
            unset($string[$k]);
        }
    }

    if (!$full) $string = array_slice($string, 0, 1);
    return $string ? implode(', ', $string) . ' ago' : 'just now';
}

function getActivityIcon($action) {
    $icons = [
        'cpanel_login' => 'login',
        'file_upload' => 'upload',
        'db_create' => 'database',
        'email_create' => 'mail',
        'backup' => 'backup',
        'setting_update' => 'settings'
    ];
    return $icons[$action] ?? 'event';
}
?>