<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {

        include_once 'includes/config.php';

        if (isset($_POST['action']) && $_POST['action'] == 'verify_email') {
            $verificationToken = $_POST['token'];

            // Check if the token exists in the email_verification table
            $sql = "SELECT user_id FROM `email_verification` WHERE token = ?";
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, "s", $verificationToken);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_bind_result($stmt, $userId);

            if (mysqli_stmt_fetch($stmt)) {
                // Token is valid, mark the user's email as verified
                mysqli_stmt_close($stmt); // Close the current statement

                // Update the user's email verification status
                $updateSql = "UPDATE `users` SET email_verified = 1 WHERE user_id = ?";
                $updateStmt = mysqli_prepare($conn, $updateSql);
                mysqli_stmt_bind_param($updateStmt, "i", $userId);
                mysqli_stmt_execute($updateStmt);
                mysqli_stmt_close($updateStmt);

                // Delete all verification tokens for this user from the email_verification table
                $deleteSql = "DELETE FROM `email_verification` WHERE user_id = ?";
                $deleteStmt = mysqli_prepare($conn, $deleteSql);
                mysqli_stmt_bind_param($deleteStmt, "i", $userId);
                mysqli_stmt_execute($deleteStmt);
                mysqli_stmt_close($deleteStmt);

                // Redirect the user to a confirmation page
                $response = array('status' => 'success', 'message' => $lang['user-email-verify-success']);
                echo json_encode($response);
            } else {
                mysqli_stmt_close($stmt); // Close the current statement

                $response = array('status' => 'error', 'message' => $lang['user-email-verify-error']);
                echo json_encode($response);
            }
        }

        if (isset($_POST['action']) && $_POST['action'] == 'get_email') {
            $verificationToken = $_POST['token'];

            // Check if the token exists in the email_verification table
            $sql = "SELECT user_id FROM `email_verification` WHERE token = ?";
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, "s", $verificationToken);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_bind_result($stmt, $userId);

            if (mysqli_stmt_fetch($stmt)) {
                // Token is valid, close the current statement
                mysqli_stmt_close($stmt);
                $profilePicture = getUserProfilePicture($userId, $conn);

                // Retrieve the user's email from the users table based on user_id
                $emailSql = "SELECT email FROM `users` WHERE user_id = ?";
                $emailStmt = mysqli_prepare($conn, $emailSql);
                mysqli_stmt_bind_param($emailStmt, "i", $userId);
                mysqli_stmt_execute($emailStmt);
                mysqli_stmt_bind_result($emailStmt, $userEmail);

                if (mysqli_stmt_fetch($emailStmt)) {
                    mysqli_stmt_close($emailStmt); // Close the email statement

                    // Return the email address as JSON response
                    $response = array('status' => 'success', 'email' => $userEmail, 'profile' => $profilePicture);
                    echo json_encode($response);
                } else {
                    mysqli_stmt_close($emailStmt); // Close the email statement

                    $response = array('status' => 'error', 'message' => $lang['user-email-verify-not-found']);
                    echo json_encode($response);
                }
            } else {
                mysqli_stmt_close($stmt); // Close the current statement

                $response = array('status' => 'error', 'message' => $lang['user-email-verify-error']);
                echo json_encode($response);
            }
        }
        // Close the database connection
        mysqli_close($conn);

    } else {
        // Handle CSRF token validation failure
        echo 'CSRF token validation failed';
    }
}

function getUserProfilePicture($userId, $conn) {
    // Perform a database query to fetch the user's profile picture based on $userID
    // Replace 'your_query_here' with your actual database query
    $query = "SELECT profile_picture, name, username FROM `users` WHERE user_id = ?";
    // Prepare and execute the query, binding the user ID as a parameter
    // $conn is your database connection
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $userId);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $profilePicture, $name, $username);

    // Fetch the profile picture path
    mysqli_stmt_fetch($stmt);

    // Close the statement
    mysqli_stmt_close($stmt);

    // Use the profile picture in your HTML
    if (empty($profilePicture)) {
        // Generate an avatar based on initials
        $avatar = strtoupper(substr($name, 0, 1));

        // Display the avatar
        return '<div class="relative inline-flex items-center justify-center w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-gray-600"><span class="font-medium text-gray-600 dark:text-gray-300">' . $avatar . '</span></div>';
    } else if (strpos($profilePicture, 'https://lh3.googleusercontent.com') !== false){
        // Display the user's profile picture
        return '<img class="relative inline-flex w-9 h-9 overflow-hidden rounded-full" src="' . $profilePicture . '" alt="' . htmlspecialchars($username) . ' Profile Picture">';
    }else {
        // Display the user's profile picture
        return '<img class="relative inline-flex w-9 h-9 overflow-hidden rounded-full" src="' . asset('uploads/profile_pictures/'.$profilePicture) . '" alt="' . htmlspecialchars($username) . ' Profile Picture">';
    }
}
?>
