<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {
        include_once includes('config.php');

        $passwordNew = trim($_POST['passwordNew']);
        $passwordConfirm = trim($_POST['passwordConfirm']);
        $token = trim($_POST['token']);

        // Check if the token is valid and get the email associated with the token
        $email = get_email_by_token($token, $conn);
        $validate_token = validate_token($token, $conn);

        if ($validate_token !== false) {
            // Check if the new password and confirmation match
            if ($passwordNew === $passwordConfirm) {
                // Check if the new password meets the minimum length requirement
                if (strlen($passwordNew) >= 8) {
                    // Hash the new password before storing it in the database
                    $hashedPassword = password_hash($passwordNew, PASSWORD_DEFAULT);

                    // Get the expiration time from the token in the database
                    $expirationTime = get_token_expiration($token, $conn);

                    // Check if the token has not expired
                    if (strtotime($expirationTime) > time()) {
                        // Update the user's password in the database
                        $sql = "UPDATE `users` SET `password` = ? WHERE `email` = ?";
                        $stmt = mysqli_prepare($conn, $sql);
                        mysqli_stmt_bind_param($stmt, "ss", $hashedPassword, $email); // Use 'ss' for two string parameters

                        if (mysqli_stmt_execute($stmt)) {
                            // Password updated successfully, invalidate the token
                            invalidate_token($token, $conn);

                            $response = array('status' => 'success', 'message' => $lang['user-update-password-succeed']);
                        } else {
                            $response = array('status' => 'error', 'message' => $lang['user-update-password-failed']);
                        }
                    } else {
                        $response = array('status' => 'error', 'message' => $lang['user-update-link-expired']);
                    }
                } else {
                    $response = array('status' => 'error', 'message' => $lang['user-update-password-length-error']);
                }
            } else {
                $response = array('status' => 'error', 'message' => $lang['user-update-password-not-match']);
            }
        } else {
            $response = array('status' => 'error', 'message' => $lang['user-update-invalid-expired-link']);
        }

        // Close the database connection
        mysqli_close($conn);

        echo json_encode($response);
    } else {
        // Handle CSRF token validation failure
        echo json_encode(array('status' => 'error', 'message' => 'CSRF token validation failed'));
    }
}

// Function to validate the token
function validate_token($token, $conn) {
    // Check if the token exists in the database and is not expired
    $query = "SELECT * FROM `password_reset_tokens` WHERE token = ? AND used = 0 AND expiry_time > NOW()";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 's', $token);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        return true;
    }

    return false;
}

// Function to retrieve the expiration time of the token
function get_token_expiration($token, $conn) {
    // Retrieve the expiration time of the token from the database
    $query = "SELECT expiry_time FROM `password_reset_tokens` WHERE token = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 's', $token);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        return $row['expiry_time'];
    }

    return false;
}

// Function to invalidate the token
function invalidate_token($token, $conn) {
    // Check if the token exists before updating it
    $query = "UPDATE `password_reset_tokens` SET used = 1 WHERE token = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 's', $token);
    mysqli_stmt_execute($stmt);
}
// Function to retrieve the user ID associated with the token
function get_email_by_token($token, $conn) {
    // Query to retrieve user ID based on the token
    $query = "SELECT email FROM `password_reset_tokens` WHERE token = ? AND used = 0";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, 's', $token);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        $email = $row['email'];
        return $email;
    }

    return false;
}

?>
