<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {
        include_once includes('config.php');
        include_once includes('mailer/send.php');

        if (isset($_POST['action']) && $_POST['action'] == 'resend_verification') {
            $userId = $_SESSION['user']['id'];

            // Retrieve user email and name from the database
            $sqlUser = "SELECT email, name FROM users WHERE user_id = ?";
            $stmtUser = mysqli_prepare($conn, $sqlUser);
            mysqli_stmt_bind_param($stmtUser, "i", $userId);
            mysqli_stmt_execute($stmtUser);
            mysqli_stmt_bind_result($stmtUser, $email, $name);
            mysqli_stmt_fetch($stmtUser);
            mysqli_stmt_close($stmtUser);

            // Check rate limiting - ensure the last request was more than 15 minutes ago
            $sqlRateLimit = "SELECT created_at FROM email_verification WHERE user_id = ? ORDER BY created_at DESC LIMIT 1";
            $stmtRateLimit = mysqli_prepare($conn, $sqlRateLimit);
            mysqli_stmt_bind_param($stmtRateLimit, "i", $userId);
            mysqli_stmt_execute($stmtRateLimit);
            mysqli_stmt_bind_result($stmtRateLimit, $lastResendTime);
            $hasRecord = mysqli_stmt_fetch($stmtRateLimit);
            mysqli_stmt_close($stmtRateLimit);

            if ($hasRecord) {
                $currentTime = new DateTime();
                $lastResendTime = new DateTime($lastResendTime);
                $interval = $lastResendTime->diff($currentTime);

                // Ensure the interval is at least 15 minutes
                if ($interval->days == 0 && $interval->h == 0 && $interval->i < 15) {
                    $response = array('status' => 'error', 'message' => $lang['resend-email-conformation-error']);
                    echo json_encode($response);
                    die();
                }
            }

            // Generate a new verification token
            $verificationToken = generateVerificationToken();

            // Store the token in the email_verification table
            $insertTokenSql = "INSERT INTO email_verification (user_id, token, created_at) VALUES (?, ?, ?)";
            $insertTokenStmt = mysqli_prepare($conn, $insertTokenSql);
            $currentTimestamp = (new DateTime())->format('Y-m-d H:i:s');
            mysqli_stmt_bind_param($insertTokenStmt, "iss", $userId, $verificationToken, $currentTimestamp);
            mysqli_stmt_execute($insertTokenStmt);

            // Create a verification link based on the token
            $verificationLink = url('/account/verify/'. urlencode($verificationToken));

            // Prepare verification email content
            $emailSubject = $lang['email-verification-subject'];
            $emailContent = getVerificationEmailContent($verificationLink, $name, $lang);

            // Send the verification email
            sendEmail($email, $emailSubject, $emailContent, '');

            $response = array('status' => 'success', 'message' => $lang['resend-email-conformation-success']);
            echo json_encode($response);
        }

        mysqli_close($conn);
    } else {
        echo 'CSRF token validation failed';
    }
}

function generateVerificationToken() {
    return bin2hex(random_bytes(32)); // Generates a 64-character hexadecimal string
}

function getVerificationEmailContent($verificationLink, $userName, $lang) {
    $htmlContent = file_get_contents(includes('emails/system_email.php'));

    // Replace placeholders with dynamic content
    $replacements = [
        '{{cta-link}}' => $verificationLink,
        '{{user-name}}' => $userName,
        '{{headline}}' => $lang['email-verification-headline'],
        '{{email-p1}}' => $lang['email-verification-instructions'],
        '{{cta}}' => $lang['email-verification-cta'],
        '{{email-p2}}' => $lang['email-verification-instructions-p2'],
        '{{email-p3}}' => '',

        // Language-specific replacements
        '{{hello}}' => $lang['email-hello'] ?? '',
        '{{email-copyright}}' => $lang['email-copyright'] ?? '',
        '{{best-regards}}' => $lang['best-regards'] ?? 'Best regards',
        '{{company-team}}' => $lang['company-team'] ?? 'The Datanito Team',
        '{{home}}' => $lang['email-home'] ?? 'Home',
        '{{about}}' => $lang['email-about'] ?? 'About',
        '{{products}}' => $lang['email-ai'] ?? 'Datanito AI',
        '{{contact}}' => $lang['email-contact'] ?? 'Contact',
        '{{privacy}}' => $lang['email-privacy'] ?? 'Privacy',
        '{{company-name}}' => $lang['company-name'] ?? 'Datanito Ltd.',
        '{{company-tagline}}' => $lang['company-tagline'] ?? 'Leading AI-Powered Software and Payment Solutions'
    ];

    foreach ($replacements as $placeholder => $value) {
        $htmlContent = str_replace($placeholder, $value, $htmlContent);
    }

    return $htmlContent;
}
?>
