<?php

class DB {
    private $db; // Explicitly declare the $db property

    public function __construct(){
        include_once includes('config.php');
        if(!isset($this->db)){
            // Connect to the database
            $conn = mysqli_connect(DB_HOST, DB_USERNAME, DB_PASSWORD, DB_NAME);
            if($conn->connect_error){
                die("Failed to connect with MySQL: " . $conn->connect_error);
            }else{
                $this->db = $conn;
            }
        }
    }

    public function get_user($id) {
        $sql = $this->db->query("SELECT * FROM users WHERE google_uid = '$id'");
        return $sql->fetch_assoc();
    }

    public function upsert_user($arr_data = array()) {
        $uid = $this->db->real_escape_string($arr_data['sub']);
        $name = $this->db->real_escape_string($arr_data['name']);
        $email = $this->db->real_escape_string($arr_data['email']);
        $picture = $this->db->real_escape_string($arr_data['picture']);

        // check if user exists by fetching its details
        $user = $this->get_user($uid);

        $region = $currentCountry; // Get preferred country from session

        if(!$user || !isset($user['user_id'])) {
            // If user does not exist or user_id is not provided, generate a new user ID
            $user_id = $this->generateRandomUserId(1000000000, 9999999999); // Call the method using $this

            // insert or update the user
            if (!$user) {
                // insert the user
                $sql = sprintf("INSERT INTO users(user_id, google_uid, name, email, profile_picture, preferred_region) VALUES('%s','%s', '%s', '%s', '%s', '%s')", $user_id, $uid, $name, $email, $picture, $region);
                $this->db->query($sql);
            } else {
                // update the user
                $sql = sprintf("UPDATE users SET user_id = '%s', name = '%s', email = '%s', profile_picture = '%s', preferred_region = '%s' WHERE google_uid = '%s'", $user_id, $name, $email, $picture, $region, $uid);
                $this->db->query($sql);
            }
        } else {
            // If user exists and user_id is provided, use the existing user_id
            $user_id = $user['user_id'];
        }
        // Set session cookie to expire in 1 month (2592000 seconds)
        ini_set('session.cookie_lifetime', 2592000);

        // Set session cache expiration time to 1 month (2592000 seconds)
        session_cache_expire(2592000);

        // Set session expiration time to 1 month (2592000 seconds)
        ini_set('session.gc_maxlifetime', 2592000);

        session_start();
        // Save user_id to session
        $_SESSION['user']['id'] = $user_id;
        $_SESSION['userLoggedIn'] = true;

        // Set a cookie to remember the user
        $token = $this->generateToken();
        $expires_at = date('Y-m-d H:i:s', strtotime('+30 days'));
        $this->saveTokenInDatabase($user_id, $token, $expires_at);

        setcookie('remember_token', $token, time() + (60 * 60 * 24 * 30), '/');
    }

    private function generateToken() {
        return bin2hex(random_bytes(32));
    }

    private function saveTokenInDatabase($user_id, $token, $expires_at) {
        $sql = "INSERT INTO remember_me_tokens (user_id, token, expires_at) VALUES (?, ?, ?)";
        $stmt = mysqli_prepare($this->db, $sql);
        mysqli_stmt_bind_param($stmt, "iss", $user_id, $token, $expires_at);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }
    private function generateRandomUserId($min, $max) {
        do {
            // Generate a random user ID within the specified range
            $user_id = strval(mt_rand($min, $max));

            // Pad the user ID to ensure it is 10 characters long
            $user_id = str_pad($user_id, 10, '0', STR_PAD_LEFT);

            // Check if the generated user ID is unique
            $sqlCheck = "SELECT COUNT(*) FROM `users` WHERE user_id = ?";
            $stmtCheck = mysqli_prepare($this->db, $sqlCheck); // Use $this->db instead of $conn

            // Check if the prepare statement is successful
            if ($stmtCheck) {
                mysqli_stmt_bind_param($stmtCheck, "s", $user_id);
                mysqli_stmt_execute($stmtCheck);
                mysqli_stmt_bind_result($stmtCheck, $count);
                mysqli_stmt_fetch($stmtCheck);
                mysqli_stmt_close($stmtCheck);
            } else {
                // Handle prepare statement failure
                die('mysqli_prepare failed');
            }
        } while ($count > 0);

        return $user_id;
    }
}

