<?php
// Verify the purchase code and provide download links
if (empty($code)) {
    http_response_code(400);
    echo json_encode(['error' => 'Purchase code is required']);
    exit;
}

$purchase_code = trim($code);
$personal_token = 'zBnE49cyHSz7ccfyXmGHhB54aDWQ5Qxv';

// Define a sample license key for testing
$test_license_key = '12345678-1234-1234-1234-123456789abc';

if (!preg_match("/^([a-f0-9]{8})-(([a-f0-9]{4})-){3}([a-f0-9]{12})$/i", $purchase_code)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid purchase code format']);
    exit;
}

// Check if the purchase code matches the test license key
if ($purchase_code === $test_license_key) {
    // Simulate a successful response for the test license key
    $test_response = [
        'item' => [
            'name' => 'Test Item',
            'id' => 123456,
        ],
        'buyer' => 'testbuyer',
        'license' => 'Regular License',
        'supported_until' => '2024-12-31T23:59:59+00:00',
        'demo_content_links' => [
            'cryptotap_sql' => 'https://studio.datanito.com/scripts/cryptotap/demo/cryptotap.sql',
        ],
    ];
    echo json_encode($test_response);
    exit;
}

// Make the API request to Envato
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://api.envato.com/v3/market/author/sale?code=' . urlencode($purchase_code));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $personal_token,
    'User-Agent: Purchase code verification script'
]);
$response_body = curl_exec($ch);
$response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Check for errors
if ($response_code !== 200) {
    $error_message = json_decode($response_body, true);
    if ($error_message && isset($error_message['error'])) {
        echo json_encode(['error' => $error_message['error']]);
    } else {
        http_response_code($response_code);
        echo $response_body;
    }
    exit;
}

// Parse the JSON response
$body = json_decode($response_body, true);

// Check if JSON parsing was successful
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Error parsing API response',
        'response_body' => $response_body, // Add this line to debug the actual response body
        'json_error' => json_last_error_msg() // Add this line to show the JSON error message
    ]);
    exit;
}

// Return the response with demo content links and plugin link
$response = $body;
$response['demo_content_links'] = [
    'cryptotap_sql' => 'https://studio.datanito.com/scripts/cryptotap/demo/cryptotap.sql',
];
echo json_encode($response);

echo json_encode($response);
?>

