<?php
session_start();

// Include your database configuration file
include_once includes('config.php');

// Check if a user is logged in
if (isset($_SESSION['user']) && $_SESSION['user']['role'] === 'admin') {
    $user_id = $_SESSION['user']['id'];

    // Fetch ticket data for the logged-in user from the database
    $query = "SELECT * FROM users ORDER BY created_at ASC";
    $stmt = mysqli_prepare($conn, $query);

    if (!$stmt) {
        $response = array('success' => false, 'message' => 'Error preparing statement');
    } else {
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        if (!$result) {
            $response = array('success' => false, 'message' => 'Error fetching tickets');
        } else {
            $users = array();
            while ($row = mysqli_fetch_assoc($result)) {
                $users[] = $row;
            }
            $response = array('success' => true, 'users' => $users);
        }
    }

    mysqli_stmt_close($stmt);
} else {
    // User is not logged in
    $response = array('success' => false, 'message' => 'User is not logged in');
}

mysqli_close($conn);

echo json_encode($response);
?>
