<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {

        include_once includes('config.php');

        // Replace this with your authentication and user role checking logic
        if (!isset($_SESSION['user'])) {
            $response = array('success' => false, 'message' => 'Access denied');
            echo json_encode($response);
            exit;
        }

        $ticketId = $_POST['ticket_id']; // You need to pass the ticket ID as a POST parameter

        // Fetch ticket details
        $ticketQuery = "SELECT id, subject, status, created_at, user_id FROM support_tickets WHERE id = ?";
        $ticketStmt = mysqli_prepare($conn, $ticketQuery);
        mysqli_stmt_bind_param($ticketStmt, 'i', $ticketId);
        mysqli_stmt_execute($ticketStmt);
        mysqli_stmt_bind_result($ticketStmt, $ticketId, $subject, $status, $created_at, $user_id);
        mysqli_stmt_fetch($ticketStmt);
        mysqli_stmt_close($ticketStmt);

        // Fetch message history with ordering
        $messageQuery = "SELECT message, user_type, attachment_filename, created_at FROM support_messages WHERE ticket_id = ? ORDER BY created_at DESC";
        $messageStmt = mysqli_prepare($conn, $messageQuery);
        mysqli_stmt_bind_param($messageStmt, 'i', $ticketId);
        mysqli_stmt_execute($messageStmt);
        $messageResult = mysqli_stmt_get_result($messageStmt);

        $messages = array();
        while ($row = mysqli_fetch_assoc($messageResult)) {
            $messages[] = $row;
        }

        // Query to retrieve user information
        $queryClientInfo = "SELECT name, profile_picture, username FROM users WHERE user_id = ?";

        // Prepare and execute the query
        $stmt = $conn->prepare($queryClientInfo);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();

        // Bind the result to variables
        $stmt->bind_result($user_name, $profile_picture, $user_username);

        // Fetch the result
        $stmt->fetch();

        // Close the statement
        $stmt->close();
        mysqli_stmt_close($messageStmt);
        mysqli_close($conn);


        $get_profile_picture = getUserAvatar($user_name, $profile_picture, $user_username);

        $response = array(
            'success' => true,
            'subject' => $subject,
            'status' => $status,
            'created_at' => $created_at,
            'messages' => $messages,
            'profile_picture' => $get_profile_picture,
        );

        echo json_encode($response);

    } else {
        // Handle CSRF token validation failure
        echo 'CSRF token validation failed';
    }
}
function getUserAvatar($user_name, $profile_picture, $user_username)
{
    // Check if the profile picture is empty
    if (empty($profile_picture)) {
        // Generate avatar based on initials
        $avatar = strtoupper(substr($user_name, 0, 1) );

        // Display the avatar
        $avatarHTML = '<div class="relative inline-flex items-center justify-center w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-gray-600"><span class="font-medium text-gray-600 dark:text-gray-300">' . $avatar . '</span></div>';
    } else {
        // Display the user's profile picture
        $avatarHTML = '<img class="relative inline-flex w-9 h-9 overflow-hidden rounded-full " src="' . asset('uploads/profile_pictures/'.$profile_picture) . '" alt="' . $user_username . ' Profile Picture">';
    }

    return $avatarHTML;
}