<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {
        include_once includes('config.php');
        header('Content-Type: text/html; charset=UTF-8');

        // Retrieve form data
        $name = $_POST['name'];
        $name_tr = $_POST['name_tr'];
        $description = $_POST['description'];
        $description_tr = $_POST['description_tr'];
        $category = $_POST['category'];
        $features = json_encode($_POST['features']);
        $features_tr = json_encode($_POST['features_tr'], JSON_UNESCAPED_UNICODE);

        if (isset($_FILES["image"]) && is_file($_FILES["image"])) {
            $target_dir = "/assets/uploads/products/";
            $target_file = $target_dir . basename($_FILES["image"]["name"]);

            // Check if file already exists
            if (file_exists($target_file)) {
                echo "Sorry, file already exists.";
            } else {
                // Check file size
                if ($_FILES["image"]["size"] > 1048576) { // 1MB
                    echo "Sorry, your file is too large.";
                } else {
                    // Allow only specific file formats (e.g., JPEG, PNG)
                    $allowed_formats = array("jpg", "jpeg", "png");
                    $file_extension = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
                    if (!in_array($file_extension, $allowed_formats)) {
                        echo "Sorry, only JPG, JPEG, and PNG files are allowed.";
                    } else {
                        // Upload the file
                        if (move_uploaded_file($_FILES["image"]["tmp_name"], $_SERVER['DOCUMENT_ROOT'].$target_file)) {
                            // Image uploaded successfully
                        } else {
                            echo "Sorry, there was an error uploading your file.";
                        }
                    }
                }
            }
        } else {
        }

        // Retrieve prices data
        $prices = $_POST['prices'];

        // Insert product details into the "products" table
        $product_sql = "INSERT INTO products (name, name_tr, description, description_tr, features, features_tr, picture, price_usd, price_eur, price_gbp, price_try, category) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = mysqli_prepare($conn, $product_sql);
        mysqli_stmt_bind_param($stmt, "ssssssssddds", $name, $name_tr, $description, $description_tr, $features, $features_tr, $target_file, $prices['USD'], $prices['EUR'], $prices['GBP'], $prices['TRY'], $category);

        if (mysqli_stmt_execute($stmt)) {
            // Product added successfully
            $response = array('status' => 'success', 'message' => 'Product added successfully!');
            echo json_encode($response);
        } else {
            // Error adding product
            $response = array('status' => 'error', 'message' => 'Error adding product: ' . mysqli_error($conn));
            echo json_encode($response);
        }

        // Close the product statement and the database connection
        mysqli_stmt_close($stmt);
        mysqli_close($conn);
    } else {
        // Handle CSRF token validation failure
        echo 'CSRF token validation failed';
    }
}
?>
