<?php
include_once includes('config.php');

header('Content-Type: application/json');

// Define your TL to USD exchange rate
$tlRate = 0.036; // Example rate; replace with the actual rate from your application

// Function to get currency sign
function getCurrencySign($currency)
{
    $currencySigns = [
        'usd' => '$',
        'eur' => '€',
        'gbp' => '£',
        'try' => ' TL',
    ];
    return $currencySigns[$currency] ?? '$';
}

// Function to handle errors and send a response
function sendErrorResponse($message)
{
    echo json_encode([
        'success' => false,
        'message' => $message,
    ]);
    exit;
}

try {
    // Fetch total sales (in TL)
    $salesQuery = "SELECT SUM(total_amount) AS total_sales FROM orders WHERE status = 'Completed'";
    $salesResult = $conn->query($salesQuery);
    if (!$salesResult) {
        throw new Exception('Error fetching total sales.');
    }
    $totalSalesTL = $salesResult->fetch_assoc()['total_sales'] ?? 0;

    // Calculate total sales in USD
    $totalSalesUSD = $totalSalesTL * $tlRate;

    // Fetch total orders
    $ordersQuery = "SELECT COUNT(*) AS total_orders FROM orders";
    $ordersResult = $conn->query($ordersQuery);
    if (!$ordersResult) {
        throw new Exception('Error fetching total orders.');
    }
    $totalOrders = $ordersResult->fetch_assoc()['total_orders'] ?? 0;

    // Fetch total customers
    $customersQuery = "SELECT COUNT(DISTINCT user_id) AS total_customers FROM orders";
    $customersResult = $conn->query($customersQuery);
    if (!$customersResult) {
        throw new Exception('Error fetching total customers.');
    }
    $totalCustomers = $customersResult->fetch_assoc()['total_customers'] ?? 0;

    // Fetch profit (in TL)
    $profitQuery = "SELECT SUM(amount) - SUM(tax_amount) AS profit FROM invoices WHERE invoice_status = 'Paid'";
    $profitResult = $conn->query($profitQuery);
    if (!$profitResult) {
        throw new Exception('Error fetching profit.');
    }
    $totalProfitTL = $profitResult->fetch_assoc()['profit'] ?? 0;

    // Calculate total profit in USD
    $totalProfitUSD = $totalProfitTL * $tlRate;

    // Fetch recent leads
    $leadsQuery = "SELECT lead_id, name, email, created_at FROM leads ORDER BY created_at DESC LIMIT 5";
    $leadsResult = $conn->query($leadsQuery);
    if (!$leadsResult) {
        throw new Exception('Error fetching leads.');
    }

    $leads = $leadsResult->fetch_all(MYSQLI_ASSOC);

    // Fetch recent orders with detailed information
    $ordersQuery = "
        SELECT 
            o.order_id, 
            o.total_amount, 
            o.order_date, 
            o.status AS order_status, 
            u.user_id AS customer_id, 
            u.name AS customer_name 
        FROM orders o
        JOIN users u ON o.user_id = u.user_id
        ORDER BY o.order_date DESC LIMIT 5";
    $ordersResult = $conn->query($ordersQuery);
    if (!$ordersResult) {
        throw new Exception('Error fetching recent orders.');
    }

    $recentOrders = $ordersResult->fetch_all(MYSQLI_ASSOC);

    // Fetch recent users
    $usersQuery = "SELECT user_id, name, email, created_at FROM users ORDER BY created_at DESC LIMIT 5";
    $usersResult = $conn->query($usersQuery);
    if (!$usersResult) {
        throw new Exception('Error fetching recent users.');
    }

    $recentUsers = $usersResult->fetch_all(MYSQLI_ASSOC);

    // Enhanced response with detailed information
    echo json_encode([
        'success' => true,
        'summary' => [
            'total_sales' => [
                'tl' => number_format($totalSalesTL, 2) . getCurrencySign('try'),
                'usd' => getCurrencySign('usd') . number_format($totalSalesUSD, 2),
            ],
            'total_orders' => $totalOrders,
            'total_customers' => $totalCustomers,
            'total_profit' => [
                'tl' => number_format($totalProfitTL, 2) . getCurrencySign('try'),
                'usd' => getCurrencySign('usd') . number_format($totalProfitUSD, 2),
            ],
        ],
        'leads' => [
            'recent' => $leads,
            'count' => count($leads),
        ],
        'orders' => [
            'recent' => $recentOrders,
            'count' => $totalOrders,
        ],
        'users' => [
            'recent' => $recentUsers,
            'count' => $totalCustomers,
        ],
    ], JSON_PRETTY_PRINT);
} catch (Exception $e) {
    sendErrorResponse('Error: ' . $e->getMessage());
}
?>
