<?php

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid()) {
        // Check if 'attachment' key exists in $_FILES array
        $emailAttachment = isset($_FILES['attachment']) ? $_FILES['attachment'] : null;

        $emailSubject = $_POST['subject'];
        $email = $_POST['email'];
        $name = $_POST['name'];
        $emailHeadline = $_POST['emailHeadline'];
        $emailMessage = $_POST['message'];
        $btnCta = $_POST['btnCta'];
        $btnLink = $_POST['btnLink'];
        $emailLang = $_POST['emailLang'];

        include_once includes('config.php');
        include_once includes('mailer/send.php');

        $emailContent = getEmailContent($name, $emailHeadline, $emailMessage, $btnCta, $btnLink, $emailLang);

        // Send the verification email with attachment
        sendEmail($email, $emailSubject, $emailContent, $emailAttachment);
        $response = array('status' => 'success', 'message' => 'Email Sent', 'icon' => 'Check icon');
        echo json_encode($response);
    } else {
        // handle CSRF token validation failure
        echo 'CSRF token validation failed';
    }
}

function getEmailContent($name, $emailHeadline, $emailMessage, $btnCta, $btnLink, $emailLang) {
    require includes('language/'.$emailLang.'.php');
    $htmlContent = file_get_contents(includes('emails/system_email.php'));

    // Replace placeholders with dynamic content
    $replacements = [
        '{{cta-link}}' => $btnLink,
        '{{user-name}}' => $name,
        '{{headline}}' => $emailHeadline,
        '{{email-p1}}' => $emailMessage,
        '{{cta}}' => $btnCta,
        '{{email-p2}}' => '',
        '{{email-p3}}' => '',

        // Language-specific replacements
        '{{hello}}' => $lang['email-hello'] ?? '',
        '{{email-copyright}}' => $lang['email-copyright'] ?? '',
        '{{best-regards}}' => $lang['best-regards'] ?? 'Best regards',
        '{{company-team}}' => $lang['company-team'] ?? 'The Datanito Team',
        '{{home}}' => $lang['email-home'] ?? 'Home',
        '{{about}}' => $lang['email-about'] ?? 'About',
        '{{products}}' => $lang['email-ai'] ?? 'Datanito AI',
        '{{contact}}' => $lang['email-contact'] ?? 'Contact',
        '{{privacy}}' => $lang['email-privacy'] ?? 'Privacy',
        '{{company-name}}' => $lang['company-name'] ?? 'Datanito Ltd.',
        '{{company-tagline}}' => $lang['company-tagline'] ?? 'Leading AI-Powered Software and Payment Solutions'
    ];

    foreach ($replacements as $placeholder => $value) {
        $htmlContent = str_replace($placeholder, $value, $htmlContent);
    }

    return $htmlContent;
}