<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid() && empty($_POST['honeypot'])) {
        include_once includes('config.php');

        // Get user ID from the session (you should implement user authentication)
        $user_id = $_SESSION['user']['id'];
        $subject = $_POST['subject'];
        $message = $_POST['message'];

        // Initialize variables for attachment handling
        $attachment_filename = null;

        // Check if a file was uploaded
        if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === UPLOAD_ERR_OK) {
            // Specify the destination directory with the full server path
            $uploadDirectory = $_SERVER['DOCUMENT_ROOT'] . '/assets/uploads/support/';

            // Get the original file name and extension
            $originalFilename = $_FILES['attachment']['name'];
            $extension = pathinfo($originalFilename, PATHINFO_EXTENSION);

            // Generate a unique filename for the uploaded file with lowercase extension
            $filename = uniqid() . '.' . strtolower($extension);

            // Move the uploaded file to the specified directory
            if (move_uploaded_file($_FILES['attachment']['tmp_name'], $uploadDirectory . $filename)) {
                // File upload was successful, store the attachment details
                $attachment_filename = $filename;
            } else {
                $response = array('success' => false, 'message' => $lang['error-upload-file']);
                echo json_encode($response);
                exit;
            }
        }

        // Convert line breaks to <br> tags in the message
        $message = nl2br($message);
        // Insert the support request into the database
        $insert_request_query = "INSERT INTO support_tickets (user_id, subject, status) VALUES (?, ?, 'Open')";
        $stmt = mysqli_prepare($conn, $insert_request_query);
        mysqli_stmt_bind_param($stmt, 'is', $user_id, $subject);

        if (mysqli_stmt_execute($stmt)) {
            // Support request submitted successfully
            $ticket_id = mysqli_insert_id($conn); // Get the generated ticket ID

            // Insert the message with attachment details into the database
            if (saveMessage($conn, $ticket_id, $user_id, $message, 'client', $attachment_filename)) {
                $response = array('success' => true, 'message' => $lang['support-request-sent'], 'ticket_id' => $ticket_id);
            } else {
                $response = array('success' => false, 'message' => $lang['error-inset-with-attachment']);
            }
        } else {
            $response = array('success' => false, 'message' => $lang['error-submitting-support-request']);
        }

        // Close the statement
        mysqli_stmt_close($stmt);

        mysqli_close($conn);

        // Return the JSON response
        echo json_encode($response);
    } else {
        // Handle CSRF token validation failure
        echo json_encode(array('success' => false, 'message' => 'CSRF validation failed.'));
    }
}

// Function to save a message to the support_messages table
function saveMessage($conn, $ticket_id, $user_id, $message, $user_type, $attachment_filename = null) {
    $insertMessageQuery = "INSERT INTO support_messages (ticket_id, user_id, message, user_type, attachment_filename) VALUES (?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $insertMessageQuery);

    if (!$stmt) {
        return false; // Handle prepare error
    }

    mysqli_stmt_bind_param($stmt, 'iisss', $ticket_id, $user_id, $message, $user_type, $attachment_filename);

    if (!mysqli_stmt_execute($stmt)) {
        return false; // Handle execute error
    }

    mysqli_stmt_close($stmt);
    return true; // Message successfully inserted
}
?>
