<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include_once includes('config.php');
    $user_id = $_SESSION['user']['id'];
    $categories = $_POST['order_numbers']; // Get categories from the AJAX request

    // You can split the categories into an array if they are comma-separated
    $categories = explode(',', $categories);

    // Define the query to fetch orders based on the specified categories
// Define the query to fetch orders based on the specified categories
    $query = "SELECT orders.*, products.category, orders.renewal_date, orders.order_date, orders.status, orders.name
          FROM orders
          INNER JOIN products ON orders.product_id = products.product_id
          WHERE orders.user_id = ? AND orders.order_number IN (";

// Create placeholders for the categories
    $placeholders = str_repeat('?,', count($categories));
    $placeholders = rtrim($placeholders, ',');

    $query .= $placeholders . ")";


    $stmt = mysqli_prepare($conn, $query);

    if ($stmt) {
        // Bind parameters
        $params = array_merge([$user_id], $categories);
        $paramTypes = str_repeat('s', count($categories) + 1);
        mysqli_stmt_bind_param($stmt, $paramTypes, ...$params);

        // Execute the prepared statement
        mysqli_stmt_execute($stmt);

        // Get the result set
        $result = mysqli_stmt_get_result($stmt);

        $orders = [];

        while ($row = mysqli_fetch_assoc($result)) {
            // You can format and add order data to the $orders array
            $orders[] = $row;
        }

        // Free the result and close the statement
        mysqli_free_result($result);
        mysqli_stmt_close($stmt);

        // Define the language (session) and currency (session) settings
        $country = isset($_SESSION['country']) ? $_SESSION['country'] : 'en';
        $currency = isset($_SESSION['currency']) ? strtolower($_SESSION['currency']) : 'usd'; // Ensure currency code is in lowercase

        // Define the columns based on the language and currency settings
        $nameColumn = ($country === 'tr') ? 'name_tr' : 'name';
        $descriptionColumn = ($country === 'tr') ? 'description_tr' : 'description';
        $featuresColumn = ($country === 'tr') ? 'features_tr' : 'features';
        $priceColumn = 'price_' . $currency; // Ensure currency code is in lowercase

        // Prepare the product details based on the user's orders
        $products = [];

        foreach ($orders as $order) {
            $productId = $order['product_id'];

            // Query to fetch product data based on product_id
            $productQuery = "SELECT products.product_id, products.$nameColumn AS name, products.$descriptionColumn AS description, products.$featuresColumn AS features, products.picture, products.$priceColumn AS price, products.category
                    FROM products
                    WHERE products.product_id = ?";

            $productStmt = mysqli_prepare($conn, $productQuery);

            if ($productStmt) {
                mysqli_stmt_bind_param($productStmt, "s", $productId);
                mysqli_stmt_execute($productStmt);
                $productResult = mysqli_stmt_get_result($productStmt);
                $product = mysqli_fetch_assoc($productResult);

                // Add currency sign to the price
                $currencySign = getCurrencySign($currency);
                if ($currency === 'try') {
                    $product['price'] = $product['price'] . $currencySign;
                } else {
                    $product['price'] = $currencySign . $product['price'];
                }
                $product['renewal_date'] = $order['renewal_date'];
                $product['order_date'] = $order['order_date'];
                $product['status'] = $order['status'];
                // Calculate the number of days left until the renewal date
                $renewalDate = strtotime($order['renewal_date']);
                $today = time();
                $daysLeft = floor(($renewalDate - $today) / (60 * 60 * 24));

                // Include the formatted renewal date and days left in the product data
                $product['renewal_date_formatted'] = date('F j, Y', $renewalDate); // Formatted date
                $product['days_left'] = $daysLeft; // Number of days left
                $product['order_number'] = $order['order_number'];
// Check if the product name is not null before including it
                if ($order['name'] !== null) {
// $order['name'] is a JSON string, so you need to decode it into an array
                    $nameArray = json_decode($order['name'], true);
                    // Check and adapt for both 'tld' and 'ltd' cases
                    $tldKey = isset($nameArray['tld']) ? 'tld' : (isset($nameArray['ltd']) ? 'ltd' : null);

                    if ($tldKey !== null) {
                        $product['order_name'] = $nameArray['domain'] . '.' . $nameArray[$tldKey];
                    } else {
                        // Handle error or set a default value
                        $product['order_name'] = NULL;
                    }
                }
                // Format and add product data to the $products array
                $products[] = $product;

                // Close the product statement and result
                mysqli_stmt_close($productStmt);
                mysqli_free_result($productResult);
            }
        }


        // Close the database connection
        mysqli_close($conn);

        // Set the content type before echoing JSON
        header("Content-Type: application/json");

        echo json_encode($products);
    } else {
        // Handle the database query error
        echo json_encode(['error' => 'Failed to prepare and execute the statement: ' . mysqli_error($conn)]);
    }
}
function getCurrencySign($currency) {
    // Define currency signs for different currencies
    $currencySigns = [
        'usd' => '$',
        'eur' => '€',
        'gbp' => '£',
        'try' => ' TL',
    ];

    // Default to '$' if the currency is not recognized
    return $currencySigns[$currency] ?? '$';
}
?>
