<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include_once includes('config.php');

    $user_id = $_SESSION['user']['id'];

    $query = "SELECT website_id, website_url FROM analytics_websites WHERE user_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // User has added a domain, fetch analytics data for the last month for the last added domain
        $website = $result->fetch_assoc();
        $website_id = $website['website_id'];

        // Query to fetch analytics data for the last month for the last added domain
        $sql_data = "SELECT * FROM analytics_data WHERE website_id = ? AND date >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)";
        $stmt_data = $conn->prepare($sql_data);
        $stmt_data->bind_param("i", $website_id);
        $stmt_data->execute();
        $result_data = $stmt_data->get_result();
        $analytics_data = array();

        // Fetch all rows of the result set
        while ($row = $result_data->fetch_assoc()) {
            $analytics_data[] = $row;
        }

        // Close statement for analytics data
        $stmt_data->close();

        // Close statement for website info
        $stmt->close();

        // Close database connection
        $conn->close();

        // Return analytics data as JSON
        echo json_encode(array('success' => true, 'websiteInfo' => $website, 'analyticsData' => $analytics_data));
    } else {
        // No domain added for the user
        echo json_encode(array('message' => 'no_domain'));
    }
} else {
    // Invalid request method
    echo json_encode(array('message' => 'invalid_request'));
}
?>
