<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include_once includes('config.php');

    $user_id = $_SESSION['user']['id'];
    $website_url = $_POST['website_url'];
    $duration = $_POST['duration']; // Retrieve selected duration

    // Modify SQL query based on selected duration
    switch ($duration) {
        case 'last7days':
            $timeRange = "AND date >= CURDATE() - INTERVAL 7 DAY";
            break;
        case 'last28days':
            $timeRange = "AND date >= CURDATE() - INTERVAL 28 DAY";
            break;
        case 'last3months':
            $timeRange = "AND date >= CURDATE() - INTERVAL 3 MONTH";
            break;
        case 'last6months':
            $timeRange = "AND date >= CURDATE() - INTERVAL 6 MONTH";
            break;
        case 'last12months':
            $timeRange = "AND date >= CURDATE() - INTERVAL 12 MONTH";
            break;
        case 'last16months':
            $timeRange = "AND date >= CURDATE() - INTERVAL 16 MONTH";
            break;
        case 'custom':
            $startDate = $_POST['start_date'];
            $endDate = $_POST['end_date'];
            $timeRange = "AND date BETWEEN '$startDate' AND '$endDate'";
            break;
        default:
            $timeRange = ""; // Default to no time range
    }

    // SQL query to retrieve website ID based on the user and website URL
    $sql_website = "SELECT website_id, website_url FROM analytics_websites WHERE user_id = ? AND website_url = ?";
    $stmt_website = $conn->prepare($sql_website);
    $stmt_website->bind_param("is", $user_id, $website_url);
    $stmt_website->execute();
    $result_website = $stmt_website->get_result();

    if ($result_website->num_rows > 0) {
        $website = $result_website->fetch_assoc();
        $website_id = $website['website_id'];

        // Now, fetch the analytics data for this website
        $sql_data = "SELECT * FROM analytics_data WHERE website_id = ? $timeRange";
        $stmt_data = $conn->prepare($sql_data);
        $stmt_data->bind_param("i", $website_id);
        $stmt_data->execute();
        $result_data = $stmt_data->get_result();

        $analytics_data = [];
        while ($row = $result_data->fetch_assoc()) {
            $analytics_data[] = $row;
        }

        if (!empty($analytics_data)) {
            // Analytics data found, return it as JSON
            echo json_encode(array('success' => true, 'websiteInfo' => $website, 'analyticsData' => $analytics_data));
        } else {
            // No analytics data found for this website
            echo json_encode(array('success' => false, 'message' => 'No analytics data available for this website.'));
        }
    } else {
        // No website information found
        echo json_encode(array('success' => false, 'message' => 'No information available for this website.'));
    }

    $stmt_website->close();
    if (isset($stmt_data)) {
        $stmt_data->close();
    }
    $conn->close();
}
?>
