// Loading
$(document).ready(function () {
    // Show the loading animation on page load
    $(document).ready(function () {
        $("body").addClass("loaded");
        $(".skeleton").removeClass("skeleton");
        $(".loading-top").removeClass("hidden");
        setTimeout(function () {
            $(".loading-top").addClass("hidden");
        }, 1500);
    });
});


// REFRESH_LESS
// Make an AJAX request to the server to retrieve the updated content
// Bind the click event to all <a> tags in the document
// $(document).on('click', 'a', function (e) {
//     var url = $(this).attr('href');
//     var isInternalLink = url.indexOf(window.location.origin) === 0;
//     var isAnchorLink = url.indexOf('#') === 0;
//
//     if (isInternalLink && !isAnchorLink) {
//         e.preventDefault();
//         loadPage(url);
//         history.pushState({ url: url }, '', url);
//     } else if (isAnchorLink) {
//         e.preventDefault();
//         $('html, body').animate({
//             scrollTop: $(url).offset().top
//         }, 500);
//     }
// });
//
// $(document).on('submit', 'form', function (e) {
//     e.preventDefault(); // Prevent the form from submitting normally
//     var $form = $(this);
//     var url = $form.attr('action');
//     var method = $form.attr('method');
//     var formData = $form.serialize();
//
//     loadPage(url, method, formData);
// });
//
// $(window).on('popstate', function (e) {
//     var state = e.originalEvent.state;
//     if (state && state.url) {
//         loadPage(state.url);
//     }
// });
//
// function loadPage(url, method, data) {
//     $.ajax({
//         url: url,
//         type: method, // Use the method specified in the form
//         data: data,   // Use the form data for POST requests
//         dataType: 'html',
//         success: function (response) {
//             var $response = $(response);
//             var $content = $response.filter('#content');
//             $('#content').html($content.html());
//             $('.skeleton').removeClass('skeleton');
//             $(".loading-top").removeClass("hidden");
//             setTimeout(function () {
//                 $(".loading-top").addClass("hidden");
//             }, 1500);
//
//             initialScripts();
//         },
//         error: function (xhr, status, error) {
//             console.error(error);
//         }
//     });
// }

// Header
// $(document).ready(function() {
//     var header = $('.header');
//
//     $(window).scroll(function() {
//         var scroll = $(window).scrollTop();
//         var threshold = 100; // Set the desired scroll threshold
//
//         if (scroll >= threshold) {
//             header.addClass('w-full top-0');
//         } else {
//             header.removeClass('w-full top-0');
//         }
//     });
// });




$(document).ready(function () {
    // Apple-inspired Cart Implementation
    var cartItems = [];

// Load cart items from local storage
    function loadCart() {
        const storedCart = localStorage.getItem('cartItems');
        if (storedCart) {
            cartItems = JSON.parse(storedCart);
            updateCartUI();
        }
    }

// Initialize cart
    $(document).ready(() => {
        loadCart();

        // Event delegation for better performance
        $(document)
            .on('click', '.add-to-cart-btn', handleAddToCart)
            .on('click', '.add-to-cart-btn-domain', handleAddDomainToCart)
            .on('click', '.remove-item-btn', handleRemoveItem)
            .on('click', '.connect-domain-btn', handleConnectDomain)
            .on('click', '.edit-domain-btn', handleEditDomain)
            .on('click', '.save-domain-btn', handleSaveDomain)
            .on('click', '.cancel-domain-btn', handleCancelDomain);
    });

// Add product to cart
    function handleAddToCart(e) {
        e.preventDefault();
        const $button = $(this);
        const productId = $button.data('product-id');

        // Show loading state
        toggleButtonLoading($button, true);

        $.ajax({
            type: 'POST',
            url: '/add-to-cart',
            data: {
                product_id: productId,
                product_duration: $button.data('product-duration'),
                userRegion: sessionStorage.getItem('userRegion')
            },
            dataType: 'json',
            success: (data) => {
                addCartItem({
                    id: productId,
                    name: data.name,
                    price: data.price,
                    offerprice: data.offerprice,
                    currency: data.currency,
                    description: data.description,
                    picture: data.picture,
                    category: data.category,
                    package: data.package,
                    duration: $button.data('product-duration') || '1',
                    quantity: 1
                });

                toggleButtonLoading($button, false);
                openCartDrawer();
            },
            error: () => {
                toggleButtonLoading($button, false);
                showErrorToast('Failed to add item');
            }
        });
    }

// Add domain to cart
    function handleAddDomainToCart(e) {
        e.preventDefault();
        const $button = $(this);

        addCartItem({
            id: $button.data('product-id'),
            category: 'domain-name',
            name: `${$button.data('domain')}.${$button.data('tld')}`,
            domain: $button.data('domain'),
            tld: $button.data('tld'),
            price: String($button.data('price')),
            offerprice: String($button.data('offer-price')),
            currency: $button.data('currency'),
            quantity: $button.data('quantity') || 1,
            duration: $button.data('product-duration') || '1'
        });

        openCartDrawer();
    }

// Remove item from cart
    function handleRemoveItem() {
        const productId = $(this).closest('.cart-item').data('product-id');
        cartItems = cartItems.filter(item => item.id !== productId);
        saveCart();
        updateCartUI();
    }

// Domain connection handlers
    function handleConnectDomain() {
        const hostingId = $(this).closest('.cart-item').data('product-id');
        showDomainModal(hostingId);
    }

    function handleEditDomain() {
        const $container = $(this).closest('.connect-domain-form');
        const hostingId = $container.data('hosting-id');
        const item = cartItems.find(item => item.id === hostingId);

        if (item) {
            $container.find('.domain-display').hide();
            $container.find('.domain-input').show().find('input').val(item.domain ? `${item.domain}.${item.tld}` : '');
        }
    }
    function formatCurrency(amount, currency) {
        const value = typeof amount === 'string' ? parseFloat(amount.replace(',', '')) : amount;
        const formatted = value.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });

        return currency === ' TL' ?
            `${formatted}${currency}` :
            `${currency}${formatted}`;
    }

    function animateValue(element, start, end, duration, currency) {
        const range = end - start;
        const startTime = performance.now();

        function updateValue(time) {
            const elapsed = time - startTime;
            const progress = Math.min(elapsed / duration, 1);
            const value = start + (progress * range);

            element.textContent = formatCurrency(value, currency);

            if (progress < 1) {
                requestAnimationFrame(updateValue);
            }
        }

        requestAnimationFrame(updateValue);
    }

    // Helper functions
    function getItemIcon(item) {
        if (item.picture) {
            return `<img src="${item.picture}" class="w-10 h-10 rounded-md object-cover" alt="${item.name}">`;
        }

        const icons = {
            'domain-name': 'globe',
            'domain-broker': 'link',
            'web-hosting': 'cloud',
            'cloud': 'cloud',
            'business-hosting': 'database'
        };

        return `<div class="flex items-center justify-center w-10 h-10 rounded-md bg-gray-100 dark:bg-gray-700">
        <span class="material-symbols-outlined text-gray-500 dark:text-gray-300">
            ${icons[item.category] || 'shopping_bag'}
        </span>
    </div>`;
    }

    function getPriceDisplay(item, currency) {
        if (item.offerprice) {
            return `
            <span class="text-xs text-gray-400 line-through">
                ${formatCurrency(item.price, item.currency)}
            </span>
            <span class="text-sm font-medium text-gray-900 dark:text-white">
                ${formatCurrency(item.offerprice, item.currency)}
            </span>
        `;
        }
        return `<span class="text-sm font-medium text-gray-900 dark:text-white">
        ${formatCurrency(item.price, currency)}
    </span>`;
    }
    function handleSaveDomain() {
        const $container = $(this).closest('.connect-domain-form');
        const hostingId = $container.data('hosting-id');
        const fullDomain = $container.find('.domain-input input').val().trim();

        // Validate and parse domain
        if (!fullDomain) {
            showErrorToast('Please enter a domain');
            return;
        }

        const [domain, ...tldParts] = fullDomain.split('.');
        const tld = tldParts.join('.');

        if (!domain || !tld) {
            showErrorToast('Please enter a valid domain (e.g. example.com)');
            return;
        }

        // Update cart item
        const item = cartItems.find(item => item.id === hostingId);
        if (item) {
            item.domain = domain;
            item.tld = tld;
            saveCart();
            updateCartUI();
        }

        $container.find('.domain-input').hide();
        $container.find('.domain-display').show();
    }

    function handleCancelDomain() {
        const $container = $(this).closest('.connect-domain-form');
        $container.find('.domain-input').hide();
        $container.find('.domain-display').show();
    }

// Cart UI Update
    function updateCartUI() {
        const $cartEmpty = $('.cart-empty-message');
        const $cartItems = $('.cart-items-list');
        const $checkoutBtn = $('.checkout-button');

        // Empty state
        if (cartItems.length === 0) {
            $cartEmpty.show();
            $cartItems.hide();
            $checkoutBtn.prop('disabled', true).addClass('opacity-50 cursor-not-allowed');
            return;
        }

        // Build cart items
        $cartEmpty.hide();
        $checkoutBtn.prop('disabled', false).removeClass('opacity-50 cursor-not-allowed');

        const fragment = document.createDocumentFragment();
        let total = 0;
        let totalWithOffer = 0;
        const currency = cartItems[0]?.currency || '';

        cartItems.forEach(item => {
            const price = parseFloat(item.price.replace(',', ''));
            const offerPrice = item.offerprice ? parseFloat(item.offerprice.replace(',', '')) : price;

            total += price * item.quantity;
            totalWithOffer += offerPrice * item.quantity;

            fragment.appendChild(createCartItemElement(item));
        });

        // Update totals
        const taxRate = 0.2;
        const taxAmount = totalWithOffer * taxRate;
        const totalWithTax = totalWithOffer + taxAmount;
        const savings = total - totalWithOffer;
        const tax = total - totalWithTax;

        animateValue($('.subtotal')[0], 0, totalWithOffer, 500, currency);
        animateValue($('.subtotal-normal')[0], 0, total, 500, currency);
        animateValue($('.tax-estimated')[0], 0, tax, 500, currency);
        animateValue($('.saving-amount')[0], 0, savings, 500, currency);
        animateValue($('.cart-total-tax')[0], 0, totalWithTax, 500, currency);

        // Batch DOM update
        $cartItems.empty().append(fragment).show();
        updateSuggestionsVisibility();
    }

    function createCartItemElement(item) {
        const hasDomain = item.domain && item.tld;
        const domainDisplay = hasDomain ? `${item.domain}.${item.tld}` : '';

        return $(`
        <div data-product-id="${item.id}" class="cart-item group flex flex-col border-b border-gray-100 dark:border-gray-700 last:border-0 py-4 px-4">
            <div class="flex items-start justify-between">
                <!-- Product Info -->
                <div class="flex items-start space-x-4">
                    ${getItemIcon(item)}
                    <div class="flex-1 min-w-0">
                        <h3 class="text-sm font-medium text-gray-900 dark:text-white">${item.name}</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">${item.description}</p>
                    </div>
                </div>
                
                <!-- Price & Actions -->
                <div class="flex flex-col items-end">
                    ${getPriceDisplay(item)}
                    <button class="remove-item-btn mt-2 text-xs text-gray-500 hover:text-red-500 dark:hover:text-red-400 transition-colors">
                        Remove
                    </button>
                </div>
            </div>
            
            <!-- Domain Connection (for hosting items) -->
            ${item.category === 'web-hosting' || item.category === 'cloud' ? `
                <div class="connect-domain-form mt-4 pl-14" data-hosting-id="${item.id}">
                    <div class="domain-display ${hasDomain ? '' : 'hidden'}">
                        ${hasDomain ? `
                            <div class="flex items-center justify-between bg-blue-50 dark:bg-blue-900/20 rounded-lg p-3">
                                <div>
                                    <p class="text-xs font-medium text-blue-800 dark:text-blue-200">Connected domain</p>
                                    <p class="text-sm font-medium text-blue-900 dark:text-blue-100 mt-1">${domainDisplay}</p>
                                </div>
                                <button class="edit-domain-btn text-xs font-medium text-blue-600 dark:text-blue-300 hover:text-blue-800 dark:hover:text-blue-100">
                                    Edit
                                </button>
                            </div>
                        ` : `
                            <button class="connect-domain-btn w-full text-left text-xs font-medium text-blue-600 dark:text-blue-300 hover:text-blue-800 dark:hover:text-blue-100">
                                + Connect a domain
                            </button>
                        `}
                    </div>
                    
                    <div class="domain-input ${hasDomain ? 'hidden' : ''}">
                        <div class="flex items-center space-x-2">
                            <input type="text" 
                                   class="flex-1 text-sm border border-gray-300 rounded-lg px-3 py-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600" 
                                   placeholder="example.com"
                                   value="${domainDisplay}">
                            <button class="save-domain-btn text-xs font-medium text-white bg-blue-600 hover:bg-blue-700 px-3 py-2 rounded-lg">
                                Save
                            </button>
                            ${hasDomain ? `
                                <button class="cancel-domain-btn text-xs font-medium text-gray-600 dark:text-gray-300 hover:text-gray-800 dark:hover:text-gray-100">
                                    Cancel
                                </button>
                            ` : ''}
                        </div>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Enter your full domain name (e.g. example.com)</p>
                    </div>
                </div>
            ` : ''}
        </div>
    `)[0];
    }

// Helper functions
    function addCartItem(item) {
        // Check if item already exists
        const existingIndex = cartItems.findIndex(i => i.id === item.id);

        if (existingIndex >= 0) {
            // Update quantity if exists
            cartItems[existingIndex].quantity += item.quantity || 1;
        } else {
            // Add new item
            cartItems.push(item);
        }

        saveCart();
        updateCartUI();
    }

    function saveCart() {
        localStorage.setItem('cartItems', JSON.stringify(cartItems));
    }

    function toggleButtonLoading($button, isLoading) {
        const $spinner = $button.find('.spinner-status');
        const $cta = $button.find('.add-to-cart-cta');

        if (isLoading) {
            $spinner.removeClass('opacity-0 hidden');
            $cta.addClass('hidden');
            $button.prop('disabled', true);
        } else {
            $spinner.addClass('opacity-0 hidden');
            $cta.removeClass('hidden');
            $button.prop('disabled', false);
        }
    }

    function openCartDrawer() {
        const $drawer = $('.cart-drawer');
        const $backdrop = $('<div class="fixed inset-0 bg-black/50 z-30"></div>');

        $('body').append($backdrop);
        $drawer.removeClass('translate-x-full').addClass('translate-x-0');

        $backdrop.on('click', () => {
            $drawer.removeClass('translate-x-0').addClass('translate-x-full');
            $backdrop.remove();
        });
    }

    function showDomainModal(hostingId) {
        const $modal = $('#domainModal');
        $modal.data('hosting-id', hostingId);
        $modal.removeClass('hidden').addClass('flex');
    }

    function updateSuggestionsVisibility() {
        const hasDomain = cartItems.some(item => ['domain-name', 'domain-broker'].includes(item.category));
        const hasHosting = cartItems.some(item => ['web-hosting', 'cloud', 'business-hosting'].includes(item.category));

        $('.domainSuggest').toggle(!hasDomain && hasHosting);
        $('.hostingSuggest').toggle(!hasHosting && hasDomain);
        $('.serviceSuggest').toggle(!hasDomain && !hasHosting);
    }

    function showErrorToast(message) {
        // Implement your toast notification here
        console.error(message);
    }

// (Keep the other helper functions from previous implementation:
// getItemIcon, getPriceDisplay, formatCurrency, animateValue)
    updateCartUI();
});


// Put your JavaScript code here
// Login Form
$(document).ready(function () {
    const emailInput = $("#email-input");
    const emailDisplay = $("#email-display");
    const passwordInput = $("#password-input");
    const continueButton = $("#continue-button");
    const editButton = $("#edit-button");
    const step1 = $("#step-1");
    const step2 = $("#step-2");
    var csrf = $('input[name="csrf"]').val();

    let email;
// Toggle password visibility on click
    $(".password-toggle").click(function () {
        var passwordInput = $("#password-input");
        var passwordToggle = $(this).find("span");
        if (passwordInput.attr("type") === "password") {
            passwordInput.attr("type", "text");
            passwordToggle.text('visibility_off');
        } else {
            passwordInput.attr("type", "password");
            passwordToggle.text('visibility');
        }
    });

    continueButton.on("click", () => {
        // Save email and show step 2
        email = emailInput.val();
        emailDisplay.val(email);

    });

    editButton.on("click", () => {
        // Show step 1
        step1.show();
        step2.hide();
        emailInput.val(emailDisplay.val());
        $('#error_email').addClass('hidden');
        $('#error_name').addClass('hidden');
        $('#error_username').addClass('hidden');
        $('#error_password').addClass('hidden');
        $('input').removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
    });

    $("#auth-email").on("submit", (event) => {
        event.preventDefault();

        // Do login here
        $.ajax({
            type: "POST",
            url: "/auth-login",
            data: {
                email: email,
                csrf: csrf,
                action: "validate_email",
            },
            success: function (response) {
                var result = JSON.parse(response);
                if (result.status == "success") {
                    $("#step-1").hide();
                    $("#step-2").show();
                    $("#email-display").val(email);
                    emailInput.removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                    $('#error_step1').addClass('hidden');
                    $('#error_step1 .response-text').text(result.message);
                } else {
                    emailInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                    $('#error_step1').removeClass('hidden');
                    $('#error_step1 .response-text').text(result.message);
                }
            }
        });
    });

    $("#auth-login").on("submit", (event) => {
        event.preventDefault();
        const $button = $(event.currentTarget).find('[type="submit"]');
        const $spinner = $button.find('.animate-spin');
        $button.attr('disabled', true);
        $spinner.removeClass('opacity-0');
        setTimeout(() => {
            const password = $("#password-input").val();
            $.ajax({
                type: "POST",
                url: "/auth-login",
                data: {
                    email: email,
                    password: password,
                    csrf: csrf,
                },
                success: function (response) {
                    var result = JSON.parse(response);
                    if (result.status == "success") {
                        // Show the element with flex display
                        $("#toast-success").css("display", "flex");
                        $("#toast-success").removeClass("hidden");
                        $(".toast-message").text(result.message);
                        $(".toast-icon").text(result.icon);
                        $("#toast-success").removeClass("notification-closed");
                        $("#toast-success svg").addClass("notification-checkmark");
                        $("#toast-success").addClass("notification-opened");

                        // Hide the element after 2 seconds
                        setTimeout(function () {
                            $("#toast-success").addClass("notification-closed");
                            $("#toast-success").removeClass("notification-opened");
                            $("#toast-success svg").removeClass("notification-checkmark");
                            if (result.redirect) {
                                window.location.href = result.redirect;
                            } else {
                                window.location.href = "/account/overview";
                            }
                        }, 2000);
                        passwordInput.removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                        $('#error_password').addClass('hidden');
                    } else {
                        passwordInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                        $('#error_password').removeClass('hidden');
                        $('#error_password .error_message').text(result.message);
                        $('#error_password .error_icon').text(result.icon);
                    }
                },
                complete: function () {
                    $spinner.addClass('opacity-0');
                    $button.attr('disabled', false);
                }
            });
        }, 500);
    });


});

// Reset password

$(document).ready(function () {
    const step1 = $("#step-1");
    const step2 = $("#step-2");
    const emailInput = $("#email-input");
    const csrf = $('input[name="csrf"]').val();
    const resendButton = $("#resend-button"); // Get the "Resend" button element
    const sendButton = $("#continue-button"); // Get the "Resend" button element

    $("#auth-password-reset-email").text(emailInput.val()); // Set initial email value

    $("#auth-reset-password").on("submit", (event) => {
        event.preventDefault();
        sendButton.find('svg').addClass('animate-spin opacity-100');

        // Get the email value from the input field
        const email = emailInput.val();

        // Do login here
        $.ajax({
            type: "POST",
            url: "/auth-reset-password",
            data: {
                email: email,
                csrf: csrf,
            },
            success: function (response) {
                var result = JSON.parse(response);
                console.log(result);
                sendButton.find('svg').removeClass('animate-spin opacity-100');

                if (result.status == "success") {
                    $("#step-1").hide();
                    $("#step-2").show();
                    $("#auth-password-reset-email").text(email);
                    emailInput.removeClass('input__error');
                    $('#error_step1').addClass('hidden');
                    $('#error_step1 .response-text').text(result.message);
                } else {
                    emailInput.addClass('input__error');
                    $('#error_step1').removeClass('hidden');
                    $('#error_step1 .response-text').text(result.message);
                    $("#auth-password-reset-email").text(email);
                    $('.error__message').removeClass('d-none');
                }
            }
        });
    });

    // Event handler for the "Resend" button
    resendButton.on("click", function () {
        // Get the email value from the input field
        const email = emailInput.val();

        // Show loading indicator
        resendButton.find('svg').addClass('animate-spin opacity-100');

        // Disable the "Resend" button
        resendButton.prop("disabled", true);

        // Send a request to resend the email
        $.ajax({
            type: "POST",
            url: "/auth-reset-password",
            data: {
                email: email,
                csrf: csrf,
            },
            success: function (response) {
                var result = JSON.parse(response);
                console.log(result);

                // Hide loading indicator
                resendButton.find('svg').removeClass('animate-spin opacity-100');

                if (result.status == "success") {
                    // Email resend successful
                    $('#sent-again').removeClass('hidden');
                    $('#error_step2').addClass('hidden');
                    $('#sent-again .response-text').text(result.message);
                } else {
                    // Email resend failed
                    $('#sent-again').addClass('hidden');
                    $('#error_step2').removeClass('hidden');
                    $('#error_step2 .response-text').text(result.message);
                }

                // Enable the "Resend" button
                resendButton.prop("disabled", false);
            }
        });
    });
});


// Verify email


$(document).ready(function() {
    const csrf = $('input[name="csrf"]').val();
    const token = $('input[name="token"]').val();

    // Call the loadUserEmail function when the page loads


    $("#email-verification").on("submit", (event) => {
        event.preventDefault();

        // Do login here
        $.ajax({
            type: "POST",
            url: "/auth-verify-email",
            data: {
                action: "verify_email",
                token: token,
                csrf: csrf,
            },
            success: function (response) {
                var result = JSON.parse(response);
                console.log(result);
                if (result.status == "success") {
                    $('#error_step1').addClass('hidden');
                    $('#error_step1 .response-text').text(result.message);
                    $('#verified').removeClass('hidden');
                    $('#verified .response-text').text(result.message);
                } else {
                    $('#error_step1').removeClass('hidden');
                    $('#verified').addClass('hidden');
                    $('#error_step1 .response-text').text(result.message);
                }
            }
        });
    });
// Function to load user email

});

// Resend Email Confirmation

$(document).ready(function() {
    const csrf = $('input[name="csrf"]').val();
    $('#resend-verification-button').click(function(e) {
        e.preventDefault();

        $.ajax({
            url: '/auth-resend-email-confirmation',
            type: 'POST',
            data: {
                action: 'resend_verification',
                csrf: csrf,
            },
            success: function(response) {
                var result = JSON.parse(response);
                $("#toast-success").css("display", "flex");
                $("#toast-success").removeClass("hidden");
                $(".toast-message").text(result.message);
                if (result.status === 'success') {
                    $(".notification-success").removeClass("hidden");
                    $(".notification-error").addClass("hidden");
                } else {
                    $(".notification-success").addClass("hidden");
                    $(".notification-error").removeClass("hidden");
                }
                $("#toast-success").addClass("notification-opened");
                $("#toast-success svg").addClass("notification-checkmark");
                $("#toast-success").removeClass("notification-closed");
                // Hide the element after 2 seconds
                setTimeout(function () {
                    $("#toast-success").addClass("notification-closed");
                    $("#toast-success").removeClass("notification-opened");
                    $("#toast-success svg").removeClass("notification-checkmark");
                }, 2000);
            },
            error: function(xhr, status, error) {
                alert('An error occurred: ' + error);
            }
        });
    });
});

// Update password


$(document).ready(function () {
    const step1 = $("#step-1");
    const step2 = $("#step-2");
    const passwordNew = $("#new-password");
    const passwordConfirm = $("#confirm-password");
    const csrf = $('input[name="csrf"]').val();
    const token = $('input[name="token"]').val();
    const submitButton = $("#auth-update-password-button"); // Add an ID to your submit button

    // Password strength elements
    const passwordStrength = $(".auth__password_strength_item");
    const passwordStrengthIcon = $(".auth__password_strength_item .icon");

    // Function to update password strength indicator
    function updatePasswordStrengthIndicator() {
        const password = passwordNew.val();
        const passwordLength = password.length;

        if (passwordLength >= 8) {
            passwordStrength.addClass("text-green-700 dark:text-green-500");
            passwordStrength.removeClass("text-black dark:text-white");
            passwordStrengthIcon.text('check_circle');
            submitButton.prop("disabled", false); // Enable the submit button
        } else {
            passwordStrength.removeClass("text-green-700 dark:text-green-500");
            passwordStrength.addClass("text-black dark:text-white");
            passwordStrengthIcon.text('radio_button_unchecked');
            submitButton.prop("disabled", true); // Disable the submit button
        }
    }

    // Attach an input event listener to the password field
    passwordNew.on("input", updatePasswordStrengthIndicator);

    $("#auth-update-password").on("submit", (event) => {
        event.preventDefault();

        // Do login here
        $.ajax({
            type: "POST",
            url: "/auth-update-password",
            data: {
                passwordNew: passwordNew.val(),
                passwordConfirm: passwordConfirm.val(),
                token: token,
                csrf: csrf,
            },
            success: function (response) {
                var result = JSON.parse(response);
                console.log(result);
                if (result.status == "success") {
                    $("#step-1").hide();
                    $("#step-2").show();
                    passwordNew.removeClass('input__error');
                    passwordConfirm.removeClass('input__error');
                    $('#error_step1').addClass('hidden');
                    $('#error_step1 .response-text').text(result.message);
                } else {
                    passwordNew.addClass('input__error');
                    passwordConfirm.addClass('input__error');
                    $('#error_step1').removeClass('hidden');
                    $('#error_step1 .response-text').text(result.message);
                    passwordStrength.removeClass("text-green-700 dark:text-green-500");
                    passwordStrength.addClass("text-black dark:text-white");
                    passwordStrengthIcon.text('radio_button_unchecked');
                }

            }
        });
    });
});




// Siugn Up

$(document).ready(function () {
    const passwordInput = $("#password-input");
    const passwordStrength = $(".auth__password_strength_item");
    const passwordStrengthIcon = $(".auth__password_strength_item .icon");
    const emailInput = $("#email-display");
    const nameInput = $("#name-input");
    const usernameInput = $("#username-input");


    // Add an event listener to the password input field that triggers the password strength check
    passwordInput.on("input", function () {
        const password = passwordInput.val();
        const passwordLength = password.length;

        // Check if the password meets the minimum length requirement and update the password strength wrapper element accordingly
        if (passwordLength >= 8) {
            passwordStrength.addClass("text-green-700 dark:text-green-500");
            passwordStrength.removeClass("text-black dark:text-white");
            passwordStrengthIcon.text('check_circle');
            passwordInput.removeClass("input__error");
        } else {
            passwordStrength.removeClass("text-green-700 dark:text-green-500");
            passwordStrength.addClass("text-black dark:text-white");
            passwordStrengthIcon.text('radio_button_unchecked');

        }
        $('#auth-sign-up').on('submit', (event) => {
            if (passwordLength >= 8) {
                passwordStrength.removeClass("text-red-700 dark:text-red-800");
                event.preventDefault();
                const button = $("#auth-sign-up-button");
                const $spinner = button.find('.animate-spin');
                button.attr('disabled', true);
                $spinner.removeClass('opacity-0');
                setTimeout(() => {
                    const email = $("#email-display").val();
                    const name = $("#name-input").val();
                    const username = $("#username-input").val();
                    const password = $("#password-input").val();
                    const csrf = $('input[name="csrf"]').val();
                    // Handle click event on suggested username
                    $(document).on('click', '.suggested-username', function (e) {
                        e.preventDefault();
                        var clickedUsername = $(this).data('username');
                        usernameInput.val(clickedUsername);
                    });
                    $.ajax({
                        type: "POST",
                        url: "/auth-sign-up",
                        data: {
                            email: email,
                            name: name,
                            username: username,
                            password: password,
                            csrf: csrf,
                        },
                        success: function (response) {
                            var result = JSON.parse(response);
                            if (result.status == "success") {
                                // Show the element with flex display
                                $("#toast-success").css("display", "flex");
                                $("#toast-success").removeClass("hidden");
                                $(".toast-message").text(result.message);
                                $(".toast-icon").text(result.icon);
                                $("#toast-success").removeClass("notification-closed");
                                $("#toast-success svg").addClass("notification-checkmark");
                                $("#toast-success").addClass("notification-opened");

                                // Hide the element after 2 seconds
                                setTimeout(function () {
                                    $("#toast-success").addClass("notification-closed");
                                    $("#toast-success").removeClass("notification-opened");
                                    $("#toast-success svg").removeClass("notification-checkmark");
                                    if (result.redirect) {
                                        window.location.href = result.redirect;
                                    } else {
                                        window.location.href = "/account/overview";
                                    }
                                }, 2000);
                                passwordInput.removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_email').addClass('hidden');
                                $('#error_name').addClass('hidden');
                                $('#error_username').addClass('hidden');
                                $('#error_password').addClass('hidden');

                            } else if (result.reason == "email") {

                                $('input').removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_email').addClass('hidden');
                                $('#error_name').addClass('hidden');
                                $('#error_username').addClass('hidden');
                                $('#error_password').addClass('hidden');

                                emailInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_email').removeClass('hidden');
                                $('#error_email .error_message').text(result.message);
                                $('#error_email .error_icon').text(result.icon);
                            } else if (result.reason == "name") {
                                $('input').removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_email').addClass('hidden');
                                $('#error_name').addClass('hidden');
                                $('#error_username').addClass('hidden');
                                $('#error_password').addClass('hidden');

                                nameInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_name').removeClass('hidden');
                                $('#error_name .error_message').text(result.message);
                                $('#error_name .error_icon').text(result.icon);
                            } else if (result.reason == "username") {
                                $('input').removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_email').addClass('hidden');
                                $('#error_name').addClass('hidden');
                                $('#error_username').addClass('hidden');
                                $('#error_password').addClass('hidden');

                                var usernameInput = $('#username'); // Replace '#username' with the correct selector for your username input field

                                usernameInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_username').removeClass('hidden');
                                $('#error_username .error_message').html(result.message);
                                $('#error_username .error_icon').text(result.icon);
                            } else if (result.reason == "email+username") {
                                $('input').removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_email').addClass('hidden');
                                $('#error_name').addClass('hidden');
                                $('#error_username').addClass('hidden');
                                $('#error_password').addClass('hidden');

                                emailInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_email').removeClass('hidden');
                                $('#error_email .error_message').text(result.message);
                                $('#error_email .error_icon').text(result.icon);

                                usernameInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_username').removeClass('hidden');
                                $('#error_username .error_message').text(result.message);
                                $('#error_username .error_icon').text(result.icon);
                            } else if (result.reason == "password") {
                                $('input').removeClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_email').addClass('hidden');
                                $('#error_name').addClass('hidden');
                                $('#error_username').addClass('hidden');
                                $('#error_password').addClass('hidden');

                                passwordInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');
                                $('#error_password').removeClass('hidden');
                                $('#error_password .error_message').text(result.message);
                                $('#error_password .error_icon').text(result.icon);
                            } else {
                                passwordInput.addClass('dark:border-red-500 border-red-600 dark:focus:border-red-500 focus:outline-none focus:ring-0 focus:border-red-600');

                                $("#toast-success").css("display", "flex");
                                $("#toast-success").removeClass("hidden");
                                $(".toast-message").text(result.message);
                                $(".toast-icon").text(result.icon);
                                $("#toast-success").removeClass("notification-closed");
                                $("#toast-success svg").addClass("notification-checkmark");
                                $("#toast-success").addClass("notification-opened");

                                // Hide the element after 2 seconds
                                setTimeout(function () {
                                    $("#toast-success").addClass("notification-closed");
                                    $("#toast-success").removeClass("notification-opened");
                                    $("#toast-success svg").removeClass("notification-checkmark");
                                }, 2000);
                            }
                        },
                        complete: function () {
                            $spinner.addClass('opacity-0');
                            button.attr('disabled', false);
                        }
                    });
                }, 500);
            } else {
                event.preventDefault();
                $("#auth-sign-up-button").attr('disabled', true);
                passwordStrength.addClass("text-red-700 dark:text-red-800");
            }
        })
    });
});

$(document).ready(function () {
    $('.logout-action').submit(function (e) {
        e.preventDefault(); // Prevent the form from submitting normally

        $.ajax({
            url: '/logout',
            type: 'POST',
            success: function (response) {
                // Handle the response from the server
                console.log(response);

                // Refresh the current page
                location.reload();
            },
            error: function (xhr, status, error) {
                // Handle any error that occurred during the request
                console.error(error);
            }
        });
    });
});
// Search
$(document).ready(function () {
    $('#topbar-search').keyup(function () {
        var query = $(this).val();

        if (query !== '') {
            $.ajax({
                url: '/search',
                method: 'POST',
                data: {query: query},
                success: function (response) {
                    $('#search-results').html(response).removeClass('hidden');
                }
            });
        } else {
            $('#search-results').empty().addClass('hidden');
        }
    });
});

// Localization
$('.save-settings').on('click', function () {
    saveSettings();
});
$('.suggest-save-settings').on('click', function () {
    autoSettings();
});
function saveSettings() {
    var form = $('.settings-form')[0];
    var formData = new FormData(form);

    $.ajax({
        url: '/settings', // Replace with the actual URL
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function () {
            // Check the selected country and redirect accordingly
            var selectedCountry = formData.get('country');
            var currentUrl = window.location.href;

            // Function to check if the path should be excluded
            function shouldExcludePath(path) {
                var excludedPaths = ['/account']; // Add other paths to exclude if needed
                return excludedPaths.some(function (excludedPath) {
                    return path.startsWith(excludedPath);
                });
            }

            if (selectedCountry === 'tr') {
                // If selectedCountry is 'tr' (Turkey), add '/tr/' to the current URL
                if (currentUrl.indexOf('/tr') === -1 && !shouldExcludePath(currentUrl)) {
                    // Add '/tr/' before the rest of the URL
                    currentUrl = currentUrl.replace(/^(https?:\/\/[^\/]+)(\/.*)$/, '$1/tr$2');
                    // Remove any trailing slash
                    currentUrl = currentUrl.replace(/\/$/, '');
                }
            } else {
                // If selectedCountry is not 'tr', remove '/tr/' from the current URL
                currentUrl = currentUrl.replace(/\/tr\//g, '/');
                // Remove '/tr' from the end of the URL if present
                currentUrl = currentUrl.replace(/\/tr\/?$/, '');
                // Ensure there is no trailing slash added when removing '/tr'
                currentUrl = currentUrl.replace(/\/$/, '');
            }

            // Redirect the user to the calculated URL
            window.location.href = currentUrl;

        },
        error: function (xhr, status, error) {
            console.error('Error:', error);
            // Handle the error (e.g., display a message to the user)
        }
    });
}
function autoSettings() {
    var form = $('.suggest-settings-form')[0];
    var formData = new FormData(form);

    $.ajax({
        url: '/settings', // Replace with the actual URL
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function () {
            // Check the selected country and redirect accordingly
            var selectedCountry = formData.get('country');
            var currentUrl = window.location.href;

            // Function to check if the path should be excluded
            function shouldExcludePath(path) {
                var excludedPaths = ['/account']; // Add other paths to exclude if needed
                return excludedPaths.some(function (excludedPath) {
                    return path.startsWith(excludedPath);
                });
            }

            if (selectedCountry === 'tr') {
                // If selectedCountry is 'tr' (Turkey), add '/tr/' to the current URL
                if (currentUrl.indexOf('/tr') === -1 && !shouldExcludePath(currentUrl)) {
                    // Add '/tr/' before the rest of the URL
                    currentUrl = currentUrl.replace(/^(https?:\/\/[^\/]+)(\/.*)$/, '$1/tr$2');
                    // Remove any trailing slash
                    currentUrl = currentUrl.replace(/\/$/, '');
                }
            } else {
                // If selectedCountry is not 'tr', remove '/tr/' from the current URL
                currentUrl = currentUrl.replace(/\/tr\//g, '/');
                // Remove '/tr' from the end of the URL if present
                currentUrl = currentUrl.replace(/\/tr\/?$/, '');
                // Ensure there is no trailing slash added when removing '/tr'
                currentUrl = currentUrl.replace(/\/$/, '');
            }

            // Redirect the user to the calculated URL
            window.location.href = currentUrl;

        },
        error: function (xhr, status, error) {
            console.error('Error:', error);
            // Handle the error (e.g., display a message to the user)
        }
    });
}
// Function to check if the localization banner is visible
function isLocalizationBannerVisible() {
    // Adjust this selector according to your HTML structure
    return $('.localization-banner').is(':visible');
}

// Function to add or remove a CSS class from the navbar based on the visibility of the localization banner
function adjustNavbarPosition() {
    var navbar = $('.menu > ul > li > ul'); // Adjust the selector to target your navbar element
    var localizationBannerHeight = $('.localization-banner').outerHeight(); // Get the height of the localization banner

    if (isLocalizationBannerVisible()) {
        // Add a CSS class to the navbar with a top margin equal to the height of the localization banner
        navbar.addClass('with-localization-banner').css('top', localizationBannerHeight + 120 + 'px');
    } else {
        // Remove the CSS class and reset the top margin
        navbar.removeClass('with-localization-banner').css('top', '120px');
    }
}

// Function to get user's location using a third-party API (for example, ipinfo.io)
function getUserLocation() {
    return new Promise((resolve, reject) => {
        $.ajax({
            url: 'https://ipinfo.io/json',
            type: 'GET',
            dataType: 'json',
            success: resolve,
            error: reject
        });
    });
}


if (!document.cookie.includes('visited=true')) {
    getUserLocation()
        .then(data => {
            const country = data.country || 'US';
            const currency = country === 'TR' ? 'try' : 'usd';

            document.cookie = 'visited=true; max-age=31536000'; // 1 year expiration

            if (country === 'TR' && !window.location.pathname.startsWith('/tr')) {
                $('#localization-banner').removeClass('hidden');
                // Call adjustNavbarPosition after showing the localization banner
                adjustNavbarPosition();
            }


        })
        .catch(error => {
            console.error('Error getting user location:', error);
        });
}



// Mobile Menu

!function (l, s) {
    var n = {htmlClass: !0};

    function i(e, t) {
        this.element = e, this.eventController = o, this.options = l.extend({}, n, t), this.options.initialized = !1, this.init()
    }

    i.prototype.init = function () {
        var s = this.element, e = this.options, i = this.eventController.bind(this);
        !0 !== e.initialized && (i("loading"), s.find("[data-submenu]").on("click", function (e) {
            e.preventDefault();
            var t, n = l(this).attr("data-submenu"), o = l("#" + n);
            o.length && (i("opening", t = {
                subMenu: !0,
                menuId: n
            }), s.find(".submenu.current").removeClass("current"), o.addClass("opened current"), s.hasClass("submenu-opened") || s.addClass("submenu-opened"), s[0].scrollTo({top: 0}), i("opened", t))
        }), s.find("[data-submenu-close]").on("click", function (e) {
            e.preventDefault();
            var t, n = l(this).attr("data-submenu-close"), o = l("#" + n);
            o.length && (i("closing", t = {
                subMenu: !0,
                menuId: n
            }), o.removeClass("opened current"), s.find(".submenu.opened").last().addClass("current"), s.find(".submenu.opened").length || s.removeClass("submenu-opened"), o[0].scrollTo({top: 0}), i("closed", t))
        }), i("load"), this.options.htmlClass && !l("html").hasClass("mobileMenu-initialized") && l("html").addClass("mobileMenu-initialized"), e.initialized = !0)
    }, i.prototype.open = function () {
        this.eventController("opening", {subMenu: !1}), this.element.addClass("opened"), this.options.htmlClass && l("html").addClass("mobileMenu-opened"), this.eventController("opened", {subMenu: !1})
    }, i.prototype.close = function (e) {
        e || this.eventController("closing", {subMenu: !1}), this.element.removeClass("opened"), this.options.htmlClass && l("html").removeClass("mobileMenu-opened"), e || this.eventController("closed", {subMenu: !1})
    }, i.prototype.destroy = function () {
        this.eventController("destroying"), this.close(!0), this.element.find(".submenu.opened").removeClass("opened"), this.element.removeData(s), this.eventController("destroyed"), this.options = n, this.options.htmlClass && l("html").removeClass("mobileMenu-initialized"), delete this.element, delete this.options, delete this.eventController
    }, i.prototype.on = function (e, t) {
        r.call(this, e, t)
    };
    var o = function (e, t) {
        if (this.options[e]) {
            if ("function" != typeof this.options[e]) throw Error("event handler must be a function: " + e);
            this.options[e].call(this, this.element, this.options, t)
        }
    }, r = function (e, t) {
        if ("string" != typeof e) throw Error("event name is expected to be a string but got: " + typeof e);
        if ("function" != typeof t) throw Error("event handler is not a function for: " + e);
        this.options[e] = t
    };
    l.fn[s] = function (e) {
        var t, n, o;
        return t = l(this[0]), n = e, o = null, t.data(s) ? o = t.data(s) : (o = new i(t, n || {}), t.data(s, o)), o
    }
}(window.jQuery || window.cash, "mobileMenu");
$(function () {
    // init mobileMenujs side menu
    var mobileMenu = $('.mobileMenu').mobileMenu({
        opened: function () {
            // log
            console.log('the side menu opened')
        },
        closed: function () {
            // log
            console.log('the side menu closed')
        }
    })

    // dynamically bind 'closing' event
    mobileMenu.on('closing', function () {
        // log
        console.log('this event is dynamically binded')
    })

    // handle mobileMenujs overlay click
    $('.mobileMenu-overlay').on('click', function () {
        mobileMenu.close()
    })

    // open mobileMenujs side menu
    $('.btn-open').on('click', function () {
        mobileMenu.open()
    })

})
$(document).ready(function () {
    "use strict";
    var timeout;
    var activeMenuItem = null;

    $(".menu > ul > li:has(ul)").hover(function (e) {
        if ($(window).width() > 943) {
            clearTimeout(timeout);

            // Close the previously opened submenu
            if (activeMenuItem && activeMenuItem !== this) {
                $(activeMenuItem).children("ul").stop().slideUp(150);
            }

            $(this).children("ul").stop().slideDown(150);
            $('#mega-menu-overlay').stop().fadeIn(150);
            $('.header').addClass('!bg-opacity-100 dark:!bg-opacity-100'); // Add the CSS class

            // Change display property of submenu UL to flex
            $(this).children("ul").css("display", "flex");

            activeMenuItem = this; // Update the active menu item
            e.preventDefault();
        }
    }, function () {
        if ($(window).width() > 943) {
            var $submenu = $(this).children("ul");
            timeout = setTimeout(function () {
                $submenu.stop().slideUp(150);
                $('#mega-menu-overlay').stop().fadeOut(150);
                $('.header').removeClass('!bg-opacity-100 dark:!bg-opacity-100'); // Remove the CSS class
            }, 150);
        }
    });

    // Close menu on overlay click
    $('#mega-menu-overlay').on('click', function () {
        $(".menu > ul > li:has(ul)").children("ul").stop().slideUp(150);
        $(this).stop().fadeOut(150);
        $('.header').removeClass('!bg-opacity-100 dark:!bg-opacity-100'); // Remove the CSS class
        activeMenuItem = null; // Reset the active menu item
    });
});

$(document).ready(function () {
    "use strict";
    var searchFormVisible = false;
    var timeout;

    // Show/hide search form on button click
    $(".search-button").on("click", function (e) {
        e.preventDefault();
        if (!searchFormVisible) {
            $(".search-form-container").slideDown(150);
            searchFormVisible = true;
            $('#mega-menu-overlay').fadeIn(150);
            $('.header').addClass('!bg-opacity-100 dark:!bg-opacity-100'); // Add the CSS class
        } else {
            $(".search-form-container").slideUp(150);
            searchFormVisible = false;
            $('#mega-menu-overlay').fadeOut(150);
            $('.header').removeClass('!bg-opacity-100 dark:!bg-opacity-100'); // Remove the CSS class
        }
    });

    // Close search form on outside click or timeout
    $(document).on("click mousemove", function (e) {
        clearTimeout(timeout);
        if (searchFormVisible && !$(e.target).closest(".search-form-container, .search-button").length) {
            timeout = setTimeout(function () {
                $(".search-form-container").slideUp(150);
                searchFormVisible = false;
                $('#mega-menu-overlay').fadeOut(150);
                $('.header').removeClass('!bg-opacity-100 dark:!bg-opacity-100'); // Remove the CSS class
            }, 150);
        }
    });

    // Close search form on overlay click
    $('#mega-menu-overlay').on('click', function () {
        $(".search-form-container").slideUp(150);
        searchFormVisible = false;
        $('#mega-menu-overlay').fadeOut(150);
        $('.header').removeClass('!bg-opacity-100 dark:!bg-opacity-100'); // Remove the CSS class
    });
});
$(document).ready(function () {
    var searchFormVisible = false;
    var searchForm = $('.search-form');
    var searchInput = $('.search-input');
    var clearButton = $('.clear-button');
    var quickLinks = $('.quickLinks');

    // Show/hide search form on button click
    $('.search-button').on('click', function (e) {
        e.preventDefault();
        if (!searchFormVisible) {
            $('.search-form-container').slideDown(150, function () {
                $('.search-form-container .search-input').focus(); // Auto-focus on the input field
            });
            searchFormVisible = true;
            $('#mega-menu-overlay').fadeIn(150);
            $('.header').addClass('!bg-opacity-100 dark:!bg-opacity-100'); // Add the CSS class
        } else {
            $('.search-form-container').slideUp(150);
            searchFormVisible = false;
            $('#mega-menu-overlay').fadeOut(150);
            $('.header').removeClass('!bg-opacity-100 dark:!bg-opacity-100'); // Remove the CSS class
        }
    });

    // Show/hide clear button on input change
    searchInput.on('input propertychange', function () {
        if (searchInput.val().trim() !== '') {
            clearButton.fadeIn(150);
            quickLinks.fadeOut(150);
        } else {
            clearButton.fadeOut(150);
            quickLinks.fadeIn(150);
        }
    });
    // $('.search-input').on('input', function() {
    //     if ($('#drawer-search .search-input').val() !== '') {
    //         clearButton.fadeIn(150);
    //         $('.quickLinks').fadeOut(150);
    //     } else {
    //         clearButton.fadeOut(150);
    //         $('.quickLinks').fadeIn(150);
    //     }
    // });

    // Clear input and hide clear button on clear button click
    clearButton.on('click', function () {
        searchInput.val('').focus();
        $(".livesearch").html("");
        $(".suggestionSearchTerms").addClass("hidden");
        $(".domain-search-banner").addClass("hidden");
        clearButton.fadeOut(150);
        quickLinks.fadeIn(150);
    });

    // Close search form on overlay click
    $('#mega-menu-overlay').on('click', function () {
        $('.search-form-container').slideUp(150);
        searchFormVisible = false;
        $('#mega-menu-overlay').fadeOut(150);
        $('.header').removeClass('!bg-opacity-100 dark:!bg-opacity-100'); // Remove the CSS class
    });

    searchForm.on("submit", (e) => {
        e.preventDefault();
    });
});

var domainBannerVisible = false;

function showResult(str) {
    if (str.length == 0) {
        $(".livesearch").html("");
        $(".livesearch").css("border", "0px");
        $(".suggestionSearchTerms").addClass("hidden");
        $(".suggested-domain-register").addClass("hidden");
        $(".domain-search-banner").addClass("hidden");
        $('#drawer-search .quickLinks').removeClass("!hidden");
        domainBannerVisible = false;
        return;
    } else {
        $('.suggested-domain-register').text(str);
        $('.search-for-domain').attr('onclick', 'location.href=\'/domain/register?domain=' + str + "'");
        if (!domainBannerVisible) {
            $(".domain-search-banner").removeClass("hidden").hide().fadeIn(150);
            domainBannerVisible = true;
        }
        $(".suggested-domain-register").removeClass("hidden").hide().fadeIn(150);
    }

    $.ajax({
        url: "/website-search?q=" + str,
        type: "GET",
        success: function (response) {
            $(".livesearch").hide().html(response).fadeIn(150);
            $(".suggestionSearchTerms").removeClass("hidden");
            $('#drawer-search .quickLinks').addClass("!hidden");
        }
    });
}


const cards = document.querySelectorAll(".card");
// const onDocumentMouseMoveHandler = (evt) => {
//   evt.preventDefault();

//   requestAnimationFrame(() => {
//     if (!evt.target.closest('.card')) {
//       card.style.transform = 'perspective(1000px) scale(1) rotateX(0) rotateY(0)';
//     }
//   });
// };
// document.addEventListener('mousemove', onDocumentMouseMoveHandler)
cards.forEach((card) => {
    const height = card.clientHeight;
    const width = card.clientWidth;

    const mouseMoveHandler = (evt) => {
        evt.preventDefault();

        requestAnimationFrame(() => {
            const xRotation = -30 * ((evt.layerY - height / 2) / height);
            const yRotation = 20 * ((evt.layerX - width / 2) / width);

            card.style.transform = `perspective(1000px) scale(1.05) rotateX(${xRotation}deg) rotateY(${yRotation}deg)`;
        });
    };

    card.addEventListener("mousemove", mouseMoveHandler);

    card.addEventListener("mouseenter", (evt) => {
        evt.preventDefault();
        card.addEventListener("mousemove", mouseMoveHandler);
    });

    card.addEventListener("mouseout", (evt) => {
        evt.preventDefault();
        card.style.transform = "perspective(1000px) scale(1) rotateX(0) rotateY(0)";
        card.removeEventListener("mousemove", mouseMoveHandler);
    });

    card.addEventListener("click", (evt) => {
        evt.preventDefault();
        card.style.animation = "spin 1s ease-in-out";
        setTimeout(() => {
            card.style.animation = '';
        }, 1000);
    });
});

$(function () {
    var chatBox = $(".chat-box");
    var chatLogs = chatBox.find(".chat-logs");
    var chatForm = chatBox.find("#chat-form");
    var chatInput = chatForm.find("#chat-input");
    var chatSubmit = chatForm.find("#chat-submit");
    var botTypingSpeed = 5; // Typing speed for the bot response

    chatLogs.on('click', '.btn-send-message', function () {
        var button = $(this);
        var message = button.data('message');

        // Check if a message is associated with the button
        if (message) {
            // Send the message to the bot
            sendMessage(message);
        }
    });

    function loadChat() {
        chatSubmit.html('<div class="animate-spin rounded-full h-6 w-6 border-t-2 border-[#CDF140]"></div>'); // Show loading animation on send button
        chatSubmit.prop('disabled', true); // Disable the send button while bot is typing

        $.ajax({
            url: '/dino-assistant',
            method: 'POST',
            data: {message: 'welcome_message_bot'},
            success: function (response) {
                var responseData = JSON.parse(response);
                var messages = responseData.chat_messages;

                if (messages) {
                    messages.forEach(function (message, index) {
                        var isLastMessage = index === messages.length - 1;
                        generateMessage(message.text, message.sender, isLastMessage ? message.buttons : null);
                    });
                }

                scrollChatToBottom();
            },
            error: function (xhr, status, error) {
                console.error(error);
            }
        });
    }

    // Disable the send button and add typewriter animation to the bot response
    function generateMessage(msg, sender, buttons) {
        var messageClass = (sender === 'user') ? 'sent' : 'received';
        var avatar = '';
        var profilePic = sessionStorage.getItem('profilePic');

        if (sender === 'user') {
            // Check if the user is logged in and has a profile picture
            if (profilePic) {
                avatar = profilePic;
            } else {
                avatar = '<span class="material-symbols-outlined">person</span>';
            }
        } else {
            avatar = '<svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636"> <g id="surface1"> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/> </g> </svg>';
        }

        var messageHtml = (sender === 'user') ? `
        <div class="chat-msg ${messageClass}">
            <div class="cm-msg-text bg-blue-100 dark:bg-blue-900 text-gray-700 dark:text-gray-300 max-w-[75%] break-normal">${msg}</div>
            <span class="msg-avatar bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-200 ml-2">${avatar}</span>
        </div>
    ` : `
        <div class="chat-msg ${messageClass}">
            <span class="msg-avatar bg-gray-100 dark:bg-dark-600 text-gray-800 dark:text-gray-200 mr-2">${avatar}</span>
            <div class="cm-msg-text bg-gray-100 dark:bg-dark-600 text-gray-800 dark:text-gray-200 max-w-[75%] break-normal">${msg}</div>
        </div>
    `;

        chatLogs.append(messageHtml);
        scrollChatToBottom();

        if (sender === 'assistant') {
            // Disable all buttons with the class "btn-send-message"
            chatLogs.find('.btn-send-message').prop('disabled', true);

            var messageText = chatLogs.find('.cm-msg-text').last();
            var i = 0;
            var typingInterval = setInterval(function () {
                var partialMsg = msg.slice(0, i + 1);
                messageText.html(partialMsg);
                i++;
                if (i === msg.length) {
                    clearInterval(typingInterval);
                    // Enable all buttons with the class "btn-send-message" after the bot has finished typing
                    chatLogs.find('.btn-send-message').prop('disabled', false);
                    chatSubmit.html('<svg class="w-6 h-6" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24"> <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v13m0-13 4 4m-4-4-4 4"/> </svg> <span class="sr-only">Send message</span>'); // Change the send button text back to "Send"
                    chatSubmit.prop('disabled', false); // Enable the send button
                    scrollChatToBottom();
                    if (buttons && buttons.length > 0) {
                        showButtons(buttons);
                    }
                } else {
                    // Scroll to the bottom of the chat box while the bot is typing
                    scrollChatToBottom();
                }
            }, botTypingSpeed);
        }
    }

    function showButtons(buttons) {
        var buttonHtml = '<div class="cm-msg-buttons mt-[-10px] mb-5 ml-[3rem]" style="display: none;">';
        buttons.forEach(function (button) {
            if (button.link && button.action !== 'whatsapp') {
                // Link domain
                buttonHtml += `<a href="${button.link}" class="flex text-white hover:text-white w-[88%] max-w-[88%] justify-between bg-dark-700 hover:bg-dark-900 focus:outline-none focus:ring-4 focus:ring-dark-300 font-medium rounded-full text-sm px-5 py-2.5 text-center mr-2 mb-2 dark:bg-dark-500 dark:hover:bg-dark-600 dark:focus:ring-dark-800"><span></span>${button.text}<span class="material-symbols-outlined text-sm flex items-center justify-center w-6 h-6 bg-dark-500 dark:bg-dark-700 rounded-full">open_in_new</span></a>`;
            } else if (button.action === 'send' && button.message) {
                // Action domain
                buttonHtml += `<button class="btn-send-message flex items-center text-white hover:text-white w-[88%] max-w-[88%] justify-between bg-dark-700 hover:bg-dark-900 focus:outline-none focus:ring-4 focus:ring-dark-300 font-medium rounded-full text-sm px-5 py-2.5 text-center mr-2 mb-2 dark:bg-dark-500 dark:hover:bg-dark-600 dark:focus:ring-dark-800" data-message="${button.message}"><span></span>${button.text}<span class="material-symbols-outlined text-sm font-extrabold flex items-center justify-center w-6 h-6 bg-dark-500 dark:bg-dark-700 p-1 rounded-full">prompt_suggestion</span></button>`;
            } else if (button.action === 'modal' && button.modal) {
                // Modal type button
                buttonHtml += `<button type="button" class="btn-open-modal flex text-neutral-800 w-[88%] max-w-[88%] justify-between bg-[#CDF140] hover:bg-[#CDF140]/75 focus:outline-none focus:ring-4 focus:ring-dark-300 font-medium rounded-full text-sm px-5 py-2.5 text-center mr-2 mb-2 dark:focus:ring-dark-800" data-modal-target="submit-application-modal" data-modal-toggle="submit-application-modal" data-service="${button.service}" data-modal="${button.modal}"><span></span>${button.text}<span class="material-symbols-outlined text-white text-2xl flex items-center justify-center w-6 h-6 p-1 bg-dark-500 dark:bg-dark-700 rounded-full">chevron_right</span></button>`;
            } else if (button.action === 'whatsapp' && button.link) {
                buttonHtml += `<a href="${button.link}" target="_blank" class="flex items-center justify-between text-white hover:text-white w-[88%] max-w-[88%] justify-between bg-green-700 hover:bg-green-900 focus:outline-none focus:ring-4 focus:ring-dark-300 font-medium rounded-full text-sm px-5 py-2.5 text-center mr-2 mb-2 dark:bg-green-900 dark:hover:bg-green-900/75 dark:focus:ring-dark-800"><span><svg class="w-6 h-6 text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24"> <path fill="currentColor" fill-rule="evenodd" d="M12 4a8 8 0 0 0-6.895 12.06l.569.718-.697 2.359 2.32-.648.379.243A8 8 0 1 0 12 4ZM2 12C2 6.477 6.477 2 12 2s10 4.477 10 10-4.477 10-10 10a9.96 9.96 0 0 1-5.016-1.347l-4.948 1.382 1.426-4.829-.006-.007-.033-.055A9.958 9.958 0 0 1 2 12Z" clip-rule="evenodd"/> <path fill="currentColor" d="M16.735 13.492c-.038-.018-1.497-.736-1.756-.83a1.008 1.008 0 0 0-.34-.075c-.196 0-.362.098-.49.291-.146.217-.587.732-.723.886-.018.02-.042.045-.057.045-.013 0-.239-.093-.307-.123-1.564-.68-2.751-2.313-2.914-2.589-.023-.04-.024-.057-.024-.057.005-.021.058-.074.085-.101.08-.079.166-.182.249-.283l.117-.14c.121-.14.175-.25.237-.375l.033-.066a.68.68 0 0 0-.02-.64c-.034-.069-.65-1.555-.715-1.711-.158-.377-.366-.552-.655-.552-.027 0 0 0-.112.005-.137.005-.883.104-1.213.311-.35.22-.94.924-.94 2.16 0 1.112.705 2.162 1.008 2.561l.041.06c1.161 1.695 2.608 2.951 4.074 3.537 1.412.564 2.081.63 2.461.63.16 0 .288-.013.4-.024l.072-.007c.488-.043 1.56-.599 1.804-1.276.192-.534.243-1.117.115-1.329-.088-.144-.239-.216-.43-.308Z"/> </svg></span>${button.text}<span></span></a>`;
            }
        });
        buttonHtml += '</div>';
        chatLogs.append(buttonHtml);

        // Add fade-in animation to the buttons
        chatLogs.find('.cm-msg-buttons').fadeIn(500);
        chatLogs.on('click', '.btn-open-modal', function () {
            var modalId = $(this).data('modal');
            var service = $(this).data('service');
            openModal(modalId, service);
        });

        scrollChatToBottom();
    }

    function fillFormWithUserData() {
        var userName = sessionStorage.getItem('userName');
        var userEmail = sessionStorage.getItem('userEmail');
        var userPhoneNumber = sessionStorage.getItem('userPhoneNumber');

        if (userName) {
            // Set the value for the name input field
            $('#name-input-modal').val(userName);
        }

        if (userEmail) {
            // Set the value for the email input field
            $('#email-input-modal').val(userEmail);
        }

        if (userEmail) {
            // Set the value for the email input field
            $('#phone-number-input-modal').val(userPhoneNumber);
        }

    }

    function openModal(modalId, service) {
        var modal = $("#" + modalId);
        if (modal) {
            // Show the modal
            fillFormWithUserData();
            modal.removeClass('hidden');
            modal.addClass('flex backdrop-blur');
            var closeButtonModal = $('.close-modal');
            closeButtonModal.on('click', function () {
                // Close cart
                modal.addClass('hidden');
                modal.removeClass('flex backdrop-blur');
            });
            // Code to handle the modal display (e.g., centering, backdrop, etc.)
            var selectElement = modal.find("#submit-reasons-modal");
            selectElement.find('option').removeAttr('selected'); // Clear previous selection
            selectElement.find('option[value="' + service + '"]').attr('selected', true);
            // Attach form submission handling for the modal
            var form = modal.find("form");

            // Remove previous submit event handlers and attach a new one
            form.off('submit').on('submit', function (e) {
                e.preventDefault();

                // Disable the submit button to prevent multiple submissions
                var submitButton = form.find('button[type="submit"]');
                submitButton.prop("disabled", true);

                // Prepare the form data for submission
                var formData = {
                    name: $('#name-input-modal').val(),
                    csrf: $('input[name="csrf"]').val(),
                    email: $('#email-input-modal').val(),
                    phone_number: $('#phone-number-input-modal').val(),
                    submit_reason: $('#submit-reasons-modal').val(),
                    message: $('#message-input-modal').val(),
                    lead_source: 'Dino Assistant',
                    honeypot: $('#honeypot').val(),
                    promotional_offers: $('#promotional-offers').is(':checked') ? 'Yes' : 'No',
                };

                $.ajax({
                    url: '/submit_application', // Update the URL to point to your PHP script
                    method: 'POST',
                    data: formData,
                    dataType: "json",
                    success: function (response) {
                        // Show the response message in the chat
                        generateMessage(response.message, 'assistant');
                        // Clear the form after successful submission if needed
                        $('#name-input').val('');
                        $('#email-input').val('');
                        $('#phone-number-input').val('');
                        $('#submit-reasons').val('');
                        $('#message-input').val('');
                        $('#promotional-offers').prop('checked', false);
                        modal.addClass('hidden');
                    },
                    error: function (xhr, status, error) {
                        // Handle any errors if necessary
                    }
                });

                // Prevent default form submission
                return false;
            });
        }
    }

    function sendMessage(msg) {
        generateMessage(msg, 'user');
        chatSubmit.html('<div class="animate-spin rounded-full h-6 w-6 border-t-2 border-[#CDF140]"></div>'); // Show loading animation on send button
        chatSubmit.prop('disabled', true); // Disable the send button while bot is typing

        $.ajax({
            url: '/dino-assistant',
            method: 'POST',
            data: {message: msg},
            success: function (response) {
                var responseData = JSON.parse(response);
                var messages = responseData.chat_messages;

                if (messages) {
                    messages.forEach(function (message, index) {
                        var isLastMessage = index === messages.length - 1;
                        generateMessage(message.text, message.sender, isLastMessage ? message.buttons : null);
                    });
                }

                scrollChatToBottom();
            },
            error: function (xhr, status, error) {
                console.error(error);
            }
        });
    }

    function scrollChatToBottom() {
        // Get the native DOM element from jQuery object
        var chatLogsElement = chatLogs[0];

        // Scroll to the bottom of the chat box
        chatLogsElement.scrollTop = chatLogsElement.scrollHeight;
    }

    chatForm.submit(function (e) {
        e.preventDefault();
        scrollChatToBottom();
        var msg = chatInput.val().trim();
        if (msg === '') {
            return false;
        }
        sendMessage(msg);
        chatInput.val('');
    });

    $("#chat-circle, .chat-box-toggle").click(function () {
        $("#chat-circle, .chat-box").toggle('scale');
        scrollChatToBottom();
    });

    // Load previous chat messages when the page loads
    if ($("#chat-circle").is(":visible")) {
        // Load chat messages only if the chat is visible
        loadChat();
    } else {
        scrollChatToBottom();
    }
});

$(function () {
    // Get the necessary elements using jQuery
    const userInput = $('#prompt-textarea');
    const generateButton = $('#generate-button');
    const generatingArea = $('.dino-domain-generating');
    const generatingData = $('.dino-domain-generating .dinoGenerating');
    const suggestionContainer = $('#suggestion-container');
    const suggestionList = $('#suggestion-list');
    const dinoDomainIntro = $('.dinoDomainIntro');
    // Event listener for the generate button using jQuery
    generateButton.click(() => {
        const userInputValue = userInput.val();

        // Show the loading spinner and hide the suggestion container
        generatingArea.removeClass('hidden');
        suggestionContainer.addClass('hidden');
        dinoDomainIntro.addClass('hidden');
        generateButton.addClass('opacity-50 cursor-wait');
        generateButton.prop('disabled', true);
        userInput.val('');
        userInput.empty();
        // Make AJAX request to the server
        $.ajax({
            type: 'POST',
            url: '/dino/domain_suggestion', // Replace with the path to your PHP script
            data: { message: userInputValue },
            success: function(response) {
                console.log(response);
                suggestionList.empty();
                suggestionList.html(response);
                generatingArea.addClass('hidden');
                generatingData.empty();
                suggestionContainer.removeClass('hidden');
                generateButton.removeClass('opacity-50 cursor-wait');
                generateButton.prop('disabled', false);
            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error(error);
            }
        });

    });
});
$(document).ready(function() {
    $('#domainSearchForm').submit(function(event) {
        event.preventDefault();
    });

    $('#checkButton').click(function() {
        var userInput = $('#userInput').val();
        $('#results-tab').trigger('click');
        loadDomainsHistory();
        scrollToResultsArea();
        if (userInput !== '') {
            $('.spinner').addClass('inline-block');
            $('.spinner').removeClass('hidden');

            $.ajax({
                type: 'POST',
                url: '/domain/check-availability',
                data: { userInput: userInput },
                success: function(data) {
                    console.log(data);
                    $('.spinner').addClass('hidden');
                    $('#domainResults').html(data);
                    $('#results-tab').trigger('click');
                    loadDomainsHistory();
                    scrollToResultsArea();
                },error: function() {
                    // Hide the spinner on error as well
                    $('.spinner').hide();
                    $('#results-tab').trigger('click');
                }
            });
        }
    });
    // Attach a click event listener using event delegation
    $(document).on('click', '.btn-open-modal', function() {
        $('#broker-guide-modal').removeClass('hidden');
        $('#broker-guide-modal').addClass('flex backdrop-blur');
        var domain = $(this).attr('data-domain');
        var tld = $(this).attr('data-tld');
        $('.add-to-cart-btn')
            .attr('data-domain', domain)
            .attr('data-tld', tld);
    });
    function scrollToResultsArea() {
        const resultsArea = document.getElementById('domain-names-registration');
        if (!resultsArea) {
            console.error("Element with ID 'domain-names-registration' not found.");
            return;
        }

        const offset = -150; // Scroll 100px above the target
        // Calculate the top position of the target element with the offset
        const topPosition = resultsArea.getBoundingClientRect().top + window.pageYOffset + offset;

        window.scrollTo({ top: topPosition, behavior: 'smooth' });
    }

// Call the function after the DOM has fully loaded
    document.addEventListener('DOMContentLoaded', function() {
        // Assuming this is triggered by some user action, like clicking a button
        const scrollButton = document.getElementById('scroll-button');
        scrollButton.addEventListener('click', scrollToResultsArea);
    });

    $('.close-modal').on('click', function () {
        // Close cart
        $('#broker-guide-modal').addClass('hidden');
        $('#broker-guide-modal').removeClass('flex backdrop-blur');
    });
    loadFavoriteDomains();
    loadDomainsHistory();
    $(document).on('click', '.search-history-link', function() {
        var searchInput = $(this).data('search');
        $('#userInput').val(searchInput); // Fill the input field with the saved search
        $('#checkButton').trigger('click'); // Trigger the search button click
        $('#results-tab').trigger('click');
        scrollToResultsArea();
    });
    // Use event delegation for the favorite icon click event
    $('.domain-names-registration').on('click', '.favorite-icon', function() {
        var domain = $(this).attr('data-domain');
        var tld = $(this).attr('data-tld');
        var status = $(this).attr('data-status');
        var price = $(this).attr('data-price');
        var offerprice = $(this).attr('data-offer-price');
        var renderPrice = $(this).attr('data-render-price');
        var currency = $(this).attr('data-currency');
        var normalPrice = $(this).attr('data-normal-price');
        var productId = $(this).attr('data-product-id');
        var favoriteIcon = $(this);

        $.ajax({
            type: 'POST',
            url: '/domain/check-availability', // Update with the correct path
            data: { action: 'toggle_favorite', domain: domain, tld: tld,status: status, offerprice: offerprice ,price: price, itemCurrency: currency, normalPrice: normalPrice, renderPrice: renderPrice, productId: productId },
            dataType: 'json',
            success: function(response) {
                // Toggle the fill color of the SVG icon
                if (response.isFavorite) {
                    favoriteIcon.find('svg').removeClass('text-dark-600 fill-white dark:text-white dark:fill-dark-900').addClass('text-red-600 fill-red-600');
                } else {
                    favoriteIcon.find('svg').removeClass('text-red-600 fill-red-600').addClass('text-dark-600 fill-white dark:text-white dark:fill-dark-900');
                }
                loadFavoriteDomains(); // Reload the list of favorite domain
            }
        });
    });
    function loadFavoriteDomains() {
        $.ajax({
            type: 'POST',
            url: '/domain/check-availability',
            data: { action: 'get_favorites' },
            success: function(data) {
                $('.fav-spinner').hide();
                $('#fav-results').html(data);
            },error: function() {
                // Hide the spinner on error as well
                $('.fav-spinner').hide();
            }
        });
    }
    function loadDomainsHistory() {
        $.ajax({
            type: 'POST',
            url: '/domain/check-availability',
            data: { action: 'get_history' },
            success: function(data) {
                $('#history-results').html(data);
            },error: function() {
            }
        });
    }
    // Check availability functionality
    $('.check-availability-btn').click(function() {
        var domain = $(this).attr('data-domain');
        var tld = $(this).attr('data-tld');
        // Perform the availability check or update UI as needed
    });

    // Add to cart functionality
    $('.add-to-cart-domain-btn').click(function () {
        var domain = $(this).data('domain');
        var tld = $(this).data('tld');

        // Send an AJAX request to the server to add the domain to the cart
        $.ajax({
            type: 'POST', // Use POST or GET, depending on your server implementation
            url: '/add-to-cart', // Replace with your server-side script URL
            data: { domain: domain, tld: tld },
            dataType: 'json', // Assuming you expect JSON response
            success: function (response) {
                if (response.success) {
                    // Update the UI to reflect the added domain
                    // For example, update the cart summary or display a success message
                    alert('Domain added to cart: ' + domain + '.' + tld);
                } else {
                    // Handle the case where the domain could not be added
                    alert('Failed to add domain to cart: ' + response.error);
                }
            },
            error: function (xhr, status, error) {
                // Handle any errors that occur during the AJAX request
                console.error(error);
            }
        });
    });

});
$(document).ready(function () {
    // Step 1: Handle Domain Search and Navigation
    $('#domainTransferForm').submit(function (e) {
        e.preventDefault(); // Prevent form submission
        const userInput = $('#userInput').val();
        $('.transfer-domain').text(userInput);

        // Simulate navigation to the entered domain (replace with your logic)
        $('.transfer-spinner').fadeIn();

        setTimeout(function () {
            $('.transfer-spinner').fadeOut();
            $('#domain-transfer-stepper').fadeIn();
            $('.steps').eq(0).fadeIn(); // Show the first step
        }, 500); // Simulated delay
    });

    // Step 2: Handle Stepper Steps
    const steps = ['Prepare domain', 'Import web settings', 'Confirmation'];
    let currentStep = 0;

    // Function to update step and UI
// Function to update step and UI
    function updateStep(step) {
        $('.domain-transfer-cost').text('$9.99'); // Replace with actual cost

        // Hide all steps and show the current step
        $('.steps').hide();
        $('.steps').eq(step).fadeIn();

        // Update icon and background for the completed step
        $('.stepper-icon-area').eq(step).removeClass('bg-gray-100 dark:bg-gray-700').addClass('bg-green-200 dark:bg-green-900');
        $('.stepper-icon').eq(step).removeClass('text-gray-500 dark:text-gray-400').addClass('text-green-500 dark:text-green-400').text('check');
    }


    // Initialize the stepper
    updateStep(currentStep);

    // Handle "Continue" button click
    $('button#checkoutButton').click(function () {
        currentStep++;

        if (currentStep < steps.length) {
            updateStep(currentStep);
        } else {
            // All steps completed, perform final actions
            alert('Domain transfer completed!');
        }
    });
});
$(document).ready(function () {
    // Handle form submission
    var userName = sessionStorage.getItem('userName');
    var userEmail = sessionStorage.getItem('userEmail');
    var userPhoneNumber = sessionStorage.getItem('userPhoneNumber');

    if (userName) {
        // Set the value for the name input field
        $('#name-input').val(userName);
    }

    if (userEmail) {
        // Set the value for the email input field
        $('#email-input').val(userEmail);
    }
    if (userEmail) {
        // Set the value for the email input field
        $('#phone-number-input').val(userPhoneNumber);
    }

    $('.submit-application').on('submit', function (e) {
        e.preventDefault();

        // Get form data
        const formData = {
            csrf: $('input[name="csrf"]').val(),
            selected_package: $('#selected-package').val(),
            name: $('#name-input').val(),
            email: $('#email-input').val(),
            phone_number: $('#phone-number-input').val(),
            message: $('#message-input').val(),
            submit_reason: $('#submit-reasons').val(),
            lead_source: $('#lead-source').val(),
            honeypot: $('#honeypot').val(),
            promotional_offers: $('#promotional-offers').is(':checked') ? 'Yes' : 'No',
        };

        // Send data to server using AJAX
        $.ajax({
            type: 'POST',
            url: '/submit_application', // Replace with your PHP script URL
            data: formData,
            dataType: 'json',
            success: function (response) {
                // Reset form inputs
                $('#name-input').val('');
                $('#email-input').val('');
                $('#phone-number-input').val('');
                $('#submit-reasons').val('');
                $('#message-input').val('');
                $('#promotional-offers').prop('checked', false);

                // Apply green border animation to the form
                $('#apply-form').addClass('border-2 border-pulsing-green');

                $('#navigateBar').removeClass('visible');

                setTimeout(function () {
                    // Display success toast
                    $("#toast-success").css("display", "flex");
                    $("#toast-success").removeClass("hidden");
                    $(".toast-message").text(response.message);
                    $(".toast-icon").text(response.icon);
                    $("#toast-success").removeClass("notification-closed");
                    $("#toast-success svg").addClass("notification-checkmark");
                    $("#toast-success").addClass("notification-opened");
                }, 100);
                // Hide the element after 2 seconds
                setTimeout(function () {
                    $("#toast-success").addClass("notification-closed");
                    $("#toast-success").removeClass("notification-opened");
                    $("#toast-success svg").removeClass("notification-checkmark");
                    $('#apply-form').removeClass('border-2 border-pulsing-green');
                }, 2000);

            },
        });

    });
});

function initSlider(slider) {
    if(!slider) {
        return;
    }

    let currentIndex = 1;
    const interval = slider.dataset.interval ? parseInt(slider.dataset.interval) : 2500;
    const duration = slider.dataset.duration ? parseInt(slider.dataset.duration) : 250;
    let sliderItems = slider.querySelectorAll('.slot-slider-item');
    const sliderContainer = slider.querySelector('.slot-slider-items');

    if(!sliderItems.length || !sliderContainer) {
        return;
    }

    function gotoSlidePosition(slideIndex) {
        if(sliderItems[slideIndex]) {
            currentIndex = slideIndex;
            offsetY = (slider.offsetHeight / 2) - (sliderItems[slideIndex].offsetHeight / 2) - sliderItems[slideIndex].offsetTop;
            sliderContainer.style.transform = `translateY(${offsetY}px)`;
            setActiveSlide(slideIndex);

            if(slideIndex === sliderItems.length - 2) {
                window.setTimeout(() => {
                    sliderContainer.classList.add('no-transition');
                    window.setTimeout(() => {
                        gotoSlidePosition(1);
                        window.setTimeout(() => {
                            sliderContainer.classList.remove('no-transition');
                        }, 0);
                    }, duration);
                }, duration);
            }
        }
    }

    function getNextPosition() {
        if(currentIndex < sliderItems.length - 1) {
            return currentIndex + 1;
        }
        else {
            return 1;
        }
    }

    function setActiveSlide(slideIndex) {
        sliderItems.forEach((item) => {
            item.classList.remove('active');
        });
        sliderItems[slideIndex]?.classList.add('active');
    }

    sliderContainer.insertBefore(sliderItems[sliderItems.length - 1].cloneNode(true), sliderItems[0]).setAttribute('aria-hidden', 'true');
    sliderContainer.appendChild(sliderItems[0].cloneNode(true)).setAttribute('aria-hidden', 'true');
    sliderContainer.appendChild(sliderItems[1].cloneNode(true)).setAttribute('aria-hidden', 'true');

    sliderItems = slider.querySelectorAll('.slot-slider-item');

    gotoSlidePosition(currentIndex);
    window.setTimeout(() => {
        slider.classList.add('active');
    }, duration * 2);

    window.setInterval(() => {
        gotoSlidePosition(getNextPosition());
    }, interval);
}

const sliders = document.querySelectorAll('[data-slot-slider]');
sliders.forEach((slider) => {
    initSlider(slider);
});

$(document).ready(function () {
    $("#productForm").submit(function (e) {
        e.preventDefault();

        // Create a FormData object to handle the form data, including the image file
        var formData = new FormData(this);

        $.ajax({
            type: "POST",
            url: "/add_product", // Update the URL to your PHP file
            data: formData, // Use the FormData object
            processData: false,
            contentType: false,
            success: function (response) {
                // Display the success or error message
                var result = JSON.parse(response);
                $("#toast-success").css("display", "flex");
                $("#toast-success").removeClass("hidden");
                $(".toast-message").text(result.message);
                $(".toast-icon").text(result.icon);
                $("#toast-success").removeClass("notification-closed");
                $("#toast-success svg").addClass("notification-checkmark");
                $("#toast-success").addClass("notification-opened");

                // Hide the element after 2 seconds
                setTimeout(function () {
                    $("#toast-success").addClass("notification-closed");
                    $("#toast-success").removeClass("notification-opened");
                    $("#toast-success svg").removeClass("notification-checkmark");
                }, 2000);
                loadProducts();
            },
            error: function (xhr, status, error) {
                console.error(error);
                // Handle the error here if needed
            }
        });
    });
});
function loadProducts() {
    $.ajax({
        type: "POST",
        url: "/admin_get_products", // Update with the correct path to your PHP script
        dataType: "json",
        success: function (data) {
            const productList = $("#productList");
            productList.empty();

            $.each(data, function (index, product) {
                let featuresHtml = '';

                if (product.features) {
                    if (Array.isArray(product.features)) {
                        featuresHtml = '<ul>';
                        product.features.forEach(feature => {
                            featuresHtml += `<li>${feature}</li>`;
                        });
                        featuresHtml += '</ul>';
                    } else {
                        featuresHtml = product.features;
                    }
                }

                const productElement = $("<tr>");
                productElement.html(`
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                        ${product.name}
                    </th>
                    <td class="px-6 py-4">
                        ${product.description}
                    </td>
                    <td class="px-6 py-4">
                        ${product.category}
                    </td>
                    <td class="px-6 py-4">
                        ${featuresHtml ? featuresHtml : 'N/A'}
                    </td>
                    <td class="px-6 py-4">
                        <span class="p-1 rounded-md bg-gray-50 dark:bg-dark-700">${product.price_usd}</span>
                        <span class="p-1 rounded-md bg-gray-50 dark:bg-dark-700">${product.price_eur}</span>
                        <span class="p-1 rounded-md bg-gray-50 dark:bg-dark-700">${product.price_gbp}</span>
                        <span class="p-1 rounded-md bg-gray-50 dark:bg-dark-700">${product.price_try}</span>
                    </td>
                    <td class="px-6 py-4">
                        <a href="#" class="font-medium text-blue-600 dark:text-blue-500 hover:underline">Edit</a>
                    </td>
                `);
                productList.append(productElement);
            });
        },
        error: function (error) {
            console.error("Error fetching product data:", error);
        },
    });
}

$(document).ready(function () {
    $('#submitTicketForm').submit(function (e) {
        e.preventDefault();
        $.ajax({
            type: 'POST',
            url: '/open_help_request',
            data: $(this).serialize(),
            success: function (response) {
                alert(response); // Show a success message or handle redirection
            },
            error: function (error) {
                alert('Error: ' + error.responseText);
            }
        });
    });
});
function loadAdminTickets() {
    $(document).ready(function () {
        const ticketList = $('#ticketList');
        const loadingSpinner = $('.spinner');
        const emptyMessage = $('#emptyMessage');

        // Show the loading spinner while data is being loaded
        loadingSpinner.removeClass('hidden');

        // Load user-specific tickets
        $.ajax({
            type: 'POST',
            url: '/get_help_requests',
            dataType: 'json',
            success: function (data) {
                // Hide the loading spinner when data is loaded
                loadingSpinner.addClass('hidden');

                if (data.length === 0) {
                    // If no tickets found, display the empty message
                    emptyMessage.removeClass('hidden');
                } else {
                    // Clear the existing ticket list
                    ticketList.empty();
                    // Display ticket data in your HTML
                    $.each(data, function (index, ticket) {
                        function formatCreatedAt(created_at) {
                            const date = new Date(created_at);
                            const options = { year: 'numeric', month: 'long', day: 'numeric' };
                            return date.toLocaleDateString(undefined, options);
                        }
                        const formattedCreatedAt = formatCreatedAt(ticket.created_at);
                        const ticketElement = $("<tr>");
                        ticketElement.html(`
                            <th scope="row"
                                class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                ${ticket.subject}
                            </th>
                        <td class="px-6 py-4">
                            ${ticket.status}
                        </td>
                        <td class="px-6 py-4">
                            ${formattedCreatedAt}
                        </td>
                        <td class="px-6 py-4">
                            <a href="help/${ticket.ticket_id}" class="font-medium text-blue-600 dark:text-blue-500 hover:underline">View</a>
                        </td>
                    `);

                        ticketList.append(ticketElement);
                    });
                }
            },
            error: function (error) {
                // Hide the loading spinner on error
                loadingSpinner.addClass('hidden');
                alert('Error: ' + error.responseText);
            }
        });
    });
}


function getHelpHistory(id) {
    $.ajax({
        type: 'POST',
        url: '/get_help_history',
        dataType: 'json',
        data: {id: id},
        success: function (data) {
            // Update ticket details and chat history in the HTML
            $('#ticketDetails').html(data.ticketDetails);
            $('#chatHistory').html(data.chatHistory);
        },
        error: function (error) {
            console.error('Error fetching ticket details:', error);
        }
    });
}

$(document).ready(function () {
    // Select Upload-Area
    const uploadArea = document.querySelector('#uploadArea')

// Select Drop-Zoon Area
    const dropZoon = document.querySelector('#dropZoon');

// Loading Text
    const loadingText = document.querySelector('#loadingText');

// Slect File Input
    const fileInput = document.querySelector('#fileInput');

// Select Preview Image
    const previewImage = document.querySelector('#previewImage');

// File-Details Area
    const fileDetails = document.querySelector('#fileDetails');

// Uploaded File
    const uploadedFile = document.querySelector('#uploadedFile');

// Uploaded File Info
    const uploadedFileInfo = document.querySelector('#uploadedFileInfo');

// Uploaded File  Name
    const uploadedFileName = document.querySelector('.uploaded-file__name');

// Uploaded File Icon
    const uploadedFileIconText = document.querySelector('.uploaded-file__icon-text');

// Uploaded File Counter
    const uploadedFileCounter = document.querySelector('.uploaded-file__counter');

// ToolTip Data
    const toolTipData = document.querySelector('.upload-area__tooltip-data');

// Images Types
    const imagesTypes = [
        "*",
    ];

// Append Images Types Array Inisde Tooltip Data
    toolTipData.innerHTML = [...imagesTypes].join(', .');

// When (drop-zoon) has (dragover) Event
    dropZoon.addEventListener('dragover', function (event) {
        // Prevent Default Behavior
        event.preventDefault();

        // Add Class (drop-zoon--over) On (drop-zoon)
        dropZoon.classList.add('drop-zoon--over');
    });

// When (drop-zoon) has (dragleave) Event
    dropZoon.addEventListener('dragleave', function (event) {
        // Remove Class (drop-zoon--over) from (drop-zoon)
        dropZoon.classList.remove('drop-zoon--over');
    });

// When (drop-zoon) has (drop) Event
    dropZoon.addEventListener('drop', function (event) {
        // Prevent Default Behavior
        event.preventDefault();

        // Remove Class (drop-zoon--over) from (drop-zoon)
        dropZoon.classList.remove('drop-zoon--over');

        // Select The Dropped File
        const file = event.dataTransfer.files[0];

        // Call Function uploadFile(), And Send To Her The Dropped File :)
        uploadFile(file);
    });

// When (drop-zoon) has (click) Event
    dropZoon.addEventListener('click', function (event) {
        // Click The (fileInput)
        fileInput.click();
    });

// When (fileInput) has (change) Event
    fileInput.addEventListener('change', function (event) {
        // Select The Chosen File
        const file = event.target.files[0];

        // Call Function uploadFile(), And Send To Her The Chosen File :)
        uploadFile(file);
    });

// Upload File Function
    function uploadFile(file) {
        // FileReader()
        const fileReader = new FileReader();
        // File Type
        const fileType = file.type;
        // File Size
        const fileSize = file.size;

        // If File Is Passed from the (File Validation) Function
        if (fileValidate(fileType, fileSize)) {
            // Add Class (drop-zoon--Uploaded) on (drop-zoon)
            dropZoon.classList.add('drop-zoon--Uploaded');

            // Show Loading-text
            loadingText.style.display = "block";
            // Hide Preview Image
            previewImage.style.display = 'none';

            // Remove Class (uploaded-file--open) From (uploadedFile)
            uploadedFile.classList.remove('uploaded-file--open');
            // Remove Class (uploaded-file__info--active) from (uploadedFileInfo)
            uploadedFileInfo.classList.remove('uploaded-file__info--active');

            // After File Reader Loaded
            fileReader.addEventListener('load', function () {
                // After Half Second
                setTimeout(function () {
                    // Add Class (upload-area--open) On (uploadArea)
                    uploadArea.classList.add('upload-area--open');

                    // Hide Loading-text (please-wait) Element
                    loadingText.style.display = "none";
                    // Show Preview Image
                    previewImage.style.display = 'block';

                    // Add Class (file-details--open) On (fileDetails)
                    fileDetails.classList.add('file-details--open');
                    // Add Class (uploaded-file--open) On (uploadedFile)
                    uploadedFile.classList.add('uploaded-file--open');
                    // Add Class (uploaded-file__info--active) On (uploadedFileInfo)
                    uploadedFileInfo.classList.add('uploaded-file__info--active');
                }, 500); // 0.5s

                // Add The (fileReader) Result Inside (previewImage) Source
                previewImage.setAttribute('src', fileReader.result);

                // Add File Name Inside Uploaded File Name
                uploadedFileName.innerHTML = file.name;

                // Call Function progressMove();
                progressMove();
            });

            // Read (file) As Data Url
            fileReader.readAsDataURL(file);
        } else { // Else

            this; // (this) Represent The fileValidate(fileType, fileSize) Function

        };
    };

// Progress Counter Increase Function
    function progressMove() {
        // Counter Start
        let counter = 0;

        // After 600ms
        setTimeout(() => {
            // Every 100ms
            let counterIncrease = setInterval(() => {
                // If (counter) is equle 100
                if (counter === 100) {
                    // Stop (Counter Increase)
                    clearInterval(counterIncrease);
                } else { // Else
                    // plus 10 on counter
                    counter = counter + 10;
                    // add (counter) vlaue inisde (uploadedFileCounter)
                    uploadedFileCounter.innerHTML = `${counter}%`
                }
            }, 100);
        }, 600);
    };


// Simple File Validate Function
    function fileValidate(fileType, fileSize) {
        // File Type Validation
        let isImage = fileType.startsWith('image/');
        let isPDF = fileType === 'application/pdf';

        // If The Uploaded File Type Is an Image
        if (isImage) {
            // Add Inside (uploadedFileIconText) The Image Type (e.g., 'jpg', 'png', etc.)
            uploadedFileIconText.innerHTML = fileType.split('/')[1];
        } else if (isPDF) { // If The Uploaded File Type Is a PDF
            // Add Inside (uploadedFileIconText) The PDF Value
            uploadedFileIconText.innerHTML = 'pdf';
        } else { // Else
            // Add Inside (uploadedFileIconText) The Uploaded File Type
            uploadedFileIconText.innerHTML = fileType;
        }

        // Check if File Size Is 2MB or Less
        if (fileSize <= 2000000) { // 2MB
            return true;
        } else { // Else File Size
            alert('Please make sure your file is 2 Megabytes or less');
            return false;
        }
    }


// :)
});
$(document).ready(function () {
    const $loadMoreBtn = $('#load-more-btn');
    const $loadingSpinner = $('#loading-spinner');
    const $projectGrid = $('#project-grid');
    const $lazyProjects = $('.lazy');

    $loadMoreBtn.on('click', function () {
        // Show loading spinner and hide button
        $loadMoreBtn.addClass('hidden');
        $loadingSpinner.removeClass('hidden');

        setTimeout(function () {
            // Reveal hidden projects
            $lazyProjects.removeClass('hidden');
            $projectGrid.css('maxHeight', 'none'); // Remove height restriction

            // Hide loading spinner
            $loadingSpinner.addClass('hidden');
        }, 1000); // Simulate loading delay
    });
});

$(window).on('scroll', function () {
    var scrollPos = $(window).scrollTop()
    var winHeight = $(window).height()
    var docHeight = $(document).height()
    var perc = 100 * scrollPos / (docHeight - winHeight)
    $('#indicator').width(perc + '%')
})
/* ===================================
     Infinite looping animation
     ====================================== */

const wrapperEl = document.querySelector('.looping-wrapper') || false;
const numberOfEls = 100;
const duration = 6000;
const delay = duration / numberOfEls;

let tl = anime.timeline({
    duration: delay,
    complete: function () {
        tl.restart();
    }
});

function createEl(i) {
    let el = document.createElement('div');
    const rotate = (360 / numberOfEls) * i;
    const translateY = -50;
    el.classList.add('el');
    el.style.transform = 'rotate(' + rotate + 'deg) translateY(' + translateY + '%)';
    tl.add({
        begin: function () {
            anime({
                targets: el,
                rotate: [rotate + 'deg', rotate + 10 + 'deg'],
                translateY: [translateY + '%', translateY + 10 + '%'],
                scale: [1, 1.25],
                easing: 'easeInOutSine',
                direction: 'alternate',
                duration: duration * .1
            });
        }
    });
    if (wrapperEl)
        wrapperEl.appendChild(el);
}

for (let i = 0; i < numberOfEls; i++)
    createEl(i);
