<?php $__env->startSection('site_title', formatTitle([__('SERP checker'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('SERP checker')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('SERP checker')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.serp_checker')); ?>" method="post" enctype="multipart/form-data" id="serp-checker-form" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-keyword"><?php echo e(__('Keyword')); ?></label>
                <input type="text" name="keyword" id="i-keyword" class="form-control<?php echo e($errors->has('keyword') ? ' is-invalid' : ''); ?>" value="<?php echo e($keyword ?? (old('keyword') ?? '')); ?>">

                <?php if($errors->has('keyword')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('keyword')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-domain"><?php echo e(__('Domain')); ?></label>
                <input type="text" dir="ltr" name="domain" id="i-domain" class="form-control<?php echo e($errors->has('domain') ? ' is-invalid' : ''); ?>" value="<?php echo e($domain ?? (old('domain') ?? '')); ?>">

                <?php if($errors->has('domain')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('domain')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-country"><?php echo e(__('Country')); ?></label>
                <select name="country" id="i-country" class="custom-select<?php echo e($errors->has('country') ? ' is-invalid' : ''); ?>">
                    <option value="" hidden disabled selected><?php echo e(__('Country')); ?></option>
                    <?php $__currentLoopData = array_diff_key(config('countries'), array_flip(['AX', 'BQ', 'CT', 'NQ', 'FQ', 'GG', 'IM', 'JE', 'JT', 'FX', 'MI', 'ME', 'NT', 'VD', 'PC', 'PZ', 'YD', 'BL', 'MF', 'RS', 'PU', 'SU', 'ZZ', 'WK'])); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((isset($country) && $country == $key) || (!isset($country) && old('country') !== null && old('country') == $key) || (!isset($country) && config('settings.gcs_country') == $key && old('country') == null)): ?> selected <?php endif; ?>><?php echo e(__($value)); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('country')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('country')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <?php if(config('settings.captcha_serp_checker')): ?>
                        <?php echo NoCaptcha::displaySubmit('serp-checker-form', __('Search'), ['data-theme' => (config('settings.dark_mode') == 1 ? 'dark' : 'light'), 'data-size' => 'invisible', 'class' => 'btn ' . ($errors->has('g-recaptcha-response') ? 'btn-danger' : 'btn-primary')]); ?>


                        <?php echo NoCaptcha::renderJs(__('lang_code')); ?>

                    <?php else: ?>
                        <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Search')); ?></button>
                    <?php endif; ?>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.serp_checker')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>

            <?php if($errors->has('g-recaptcha-response')): ?>
                <span class="invalid-feedback d-block" role="alert">
                    <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                </span>
            <?php endif; ?>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($results)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Results')); ?></div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <?php if(empty($results) || isset($results['items']) == false): ?>
                <?php echo e(__('No results found.')); ?>

            <?php elseif(isset($results['error'])): ?>
                <?php echo e($results['error']['code'] ?? null); ?> <?php echo e($results['error']['message'] ?? null); ?>

            <?php else: ?>
                <div class="list-group list-group-flush my-n3">
                    <div class="list-group-item px-0 text-muted">
                        <div class="row align-items-center">
                            <div class="col">
                                <div class="row">
                                    <div class="col-12 d-flex align-items-center">
                                        <div class="flex-shrink-0 width-8 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">#</div>
                                        <?php echo e(__('URL')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php $__currentLoopData = $results['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="list-group-item px-0">
                            <div class="row align-items-center">
                                <div class="col text-truncate">
                                    <div class="row text-truncate">
                                        <div class="col-12 d-flex text-truncate">
                                            <div class="text-truncate">
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0 width-8 <?php echo e(($domain ? (Str::contains($result['link'], $domain) ? 'text-dark font-weight-medium' : 'text-secondary') : 'text-dark')); ?>"><?php echo e(($loop->index + 1)); ?></div>

                                                    <img src="https://icons.duckduckgo.com/ip3/<?php echo e(parse_url($result['link'], PHP_URL_HOST)); ?>.ico" rel="noreferrer" class="flex-shrink-0 width-4 height-4 mx-3">

                                                    <div class="text-truncate">
                                                        <a href="<?php echo e($result['link']); ?>" class="<?php echo e(($domain ? (Str::contains($result['link'], $domain) ? 'text-dark font-weight-medium' : 'text-secondary') : 'text-dark')); ?>" dir="ltr" rel="nofollow" target="_blank"><?php echo e(str_replace(['http://', 'https://'], '', $result['link'])); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="btn btn-sm btn-outline-primary" data-tooltip-copy="true" data-clipboard-copy="<?php echo e($result['link']); ?>" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>"><?php echo e(__('Copy')); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/serp-checker.blade.php ENDPATH**/ ?>