<?php $__env->startSection('site_title', formatTitle([$report->host, __('Report'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php if(config('settings.ad_report_top')): ?>
    <div class="d-print-none mb-1"><?php echo config('settings.ad_report_top'); ?></div>
<?php endif; ?>

<div class="d-print-none">
    <?php if(Auth::check() && Auth::user()->id == $report->user_id): ?>
        <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
            ['url' => route('dashboard'), 'title' => __('Home')],
            ['url' => route('reports', ['project' => $report->project]), 'title' => __('Reports')],
            ['title' => __('Report')]
        ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php else: ?>
        <?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
            ['url' => route('dashboard'), 'title' => __('Home')],
            ['title' => __('Report')]
        ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
</div>

<?php if($report->user->cannot('whiteLabelReports', ['App\Models\User'])): ?>
    <div class="d-none d-print-block border-bottom pb-3 mb-3">
        <div class="row">
            <div class="col">
                <div class="row no-gutters">
                    <div class="col-auto d-flex align-items-center">
                        <img src="<?php echo e(url('/')); ?>/uploads/brand/<?php echo e((config('settings.dark_mode') == 1 ? config('settings.logo_dark') : config('settings.logo'))); ?>" class="height-10 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                    </div>
                    <div class="col d-flex align-items-center">
                        <div class="">
                            <div class="font-weight-bold"><?php echo e(config('settings.title')); ?></div>

                            <div><a href="<?php echo e(route('home')); ?>" rel="nofollow" target="_blank" class="text-decoration-none"><?php echo e(route('home')); ?></a></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if($report->user->can('brandReports', ['App\Models\User', $report->user])): ?>
    <div class="d-none d-print-block border-bottom pb-3 mb-3">
        <div class="row">
            <div class="col">
                <div class="row no-gutters">
                    <div class="col-auto d-flex align-items-center">
                        <?php if(isset($report->user->brand->logo) && $report->user->brand->logo): ?>
                            <img src="<?php echo e($report->user->brand->logo); ?>" class="height-10 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                        <?php endif; ?>
                    </div>
                    <div class="col d-flex align-items-center">
                        <div class="">
                            <?php if(isset($report->user->brand->name) && $report->user->brand->name): ?>
                                <div class="font-weight-bold"><?php echo e($report->user->brand->name); ?></div>
                            <?php endif; ?>

                            <?php if(isset($report->user->brand->url) && $report->user->brand->url): ?>
                                <div><a href="<?php echo e($report->user->brand->url); ?>" rel="nofollow" target="_blank" class="text-decoration-none"><?php echo e($report->user->brand->url); ?></a></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-auto d-flex align-items-center <?php echo e((__('lang_dir') == 'rtl' ? 'text-left' : 'text-right')); ?>">
                <div>
                    <?php if(isset($report->user->brand->email) && $report->user->brand->email): ?>
                        <div><a href="mailto:<?php echo e($report->user->brand->email); ?>" class="text-secondary text-decoration-none"><?php echo e($report->user->brand->email); ?></a></div>
                    <?php endif; ?>

                    <?php if(isset($report->user->brand->phone) && $report->user->brand->phone): ?>
                        <div><a href="tel:<?php echo e($report->user->brand->phone); ?>" class="text-secondary text-decoration-none"><?php echo e($report->user->brand->phone); ?></a></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<div class="d-flex align-items-end mb-3">
    <h1 class="h2 mb-0 flex-grow-1 text-truncate"><?php echo e($report->url); ?></h1>

    <div class="d-flex align-items-center flex-grow-0 d-print-none">
        <div class="form-row flex-nowrap">
            <div class="col">
                <a href="#" class="btn text-secondary d-flex align-items-center" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo $__env->make('icons.more-horiz', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</a>

                <?php echo $__env->make('reports.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <?php if(Auth::check() && Auth::user()->id == $report->user_id): ?>
                <div class="col">
                    <form action="<?php echo e(route('reports.edit', ['id' => $report->id])); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <input name="results" type="hidden" value="true">

                        <button type="submit" class="btn text-secondary d-flex align-items-center position-relative" data-tooltip="true" title="<?php echo e(__('Refresh')); ?>" data-button-loader>
                            <div class="position-absolute top-0 right-0 bottom-0 left-0 d-flex align-items-center justify-content-center">
                                <span class="d-none spinner-border spinner-border-sm width-4 height-4" role="status"></span>
                            </div>
                            <?php echo $__env->make('icons.refresh', ['class' => 'fill-current width-4 height-4 spinner-text'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;
                        </button>
                    </form>
                </div>
            <?php endif; ?>

            <div class="col">
                <a class="btn text-secondary d-flex align-items-center" onclick="window.print();" data-tooltip="true" title="<?php echo e(__('Print')); ?>"><?php echo $__env->make('icons.print', ['class' => 'fill-current width-4 height 4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</a>
            </div>
        </div>
    </div>
</div>

<div class="d-print-none d-flex position-relative mb-3 position-xl-sticky sticky-top <?php if(auth()->guard()->check()): ?> top-lg-0 <?php else: ?> top-0 top-xl-18 <?php endif; ?> z-1000">
    <nav class="navbar navbar-expand-xl navbar-light w-100 p-0 bg-base-0 rounded shadow-sm">
        <div class="d-flex align-items-center d-xl-none px-3 py-3 font-weight-medium text-muted">
            <?php echo e(__('Menu')); ?>

        </div>
        <button class="navbar-toggler border-0 py-2 collapsed <?php echo e((__('lang_dir') == 'rtl' ? 'mr-auto' : 'ml-auto')); ?>" type="button" data-toggle="collapse" data-target="#reports-navbar" aria-controls="reports-navbar" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
            <span class="navbar-toggler-icon my-1"></span>
        </button>

        <div class="collapse navbar-collapse border-top border-top-xl-0 <?php if(auth()->guard()->check()): ?> scroll-margin-top-22 scroll-margin-top-lg-4 scroll-margin-top-xl-18 <?php else: ?> scroll-margin-top-22 scroll-margin-top-xl-36 <?php endif; ?>" id="reports-navbar">
            <ul class="navbar-nav flex-wrap justify-content-around w-100">
                <li class="nav-item">
                    <a class="nav-link d-flex align-items-center font-weight-medium py-3 px-3" href="#overview">
                        <span class="d-flex align-items-center"><?php echo $__env->make('icons.list-alt', ['class' => 'fill-current width-4 height-4 '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <span><?php echo e(__('Overview')); ?></span>
                    </a>
                </li>

                <li class="<?php echo e((__('lang_dir') == 'rtl' ? 'border-left-lg' : 'border-right-lg')); ?> "></li>

                <li class="nav-item">
                    <a class="nav-link d-flex align-items-center font-weight-medium py-3 px-3" href="#seo">
                        <span class="d-flex align-items-center"><?php echo $__env->make('icons.search', ['class' => 'fill-current width-4 height-4 '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <span><?php echo e(__('SEO')); ?></span>
                        <?php if($report->highIssuesSeoCount): ?>
                            <span class="badge badge-danger <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->highIssuesSeoCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                        <?php if($report->mediumIssuesSeoCount): ?>
                            <span class="badge badge-warning <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->mediumIssuesSeoCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                        <?php if($report->lowIssuesSeoCount): ?>
                            <span class="badge badge-secondary <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->lowIssuesSeoCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                    </a>
                </li>

                <li class="<?php echo e((__('lang_dir') == 'rtl' ? 'border-left-lg' : 'border-right-lg')); ?> "></li>

                <li class="nav-item">
                    <a class="nav-link d-flex align-items-center font-weight-medium py-3 px-3" href="#performance">
                        <span class="d-flex align-items-center"><?php echo $__env->make('icons.speed', ['class' => 'fill-current width-4 height-4 '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <span><?php echo e(__('Performance')); ?></span>
                        <?php if($report->highIssuesPerformanceCount): ?>
                            <span class="badge badge-danger <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->highIssuesPerformanceCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                        <?php if($report->mediumIssuesPerformanceCount): ?>
                            <span class="badge badge-warning <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->mediumIssuesPerformanceCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                        <?php if($report->lowIssuesPerformanceCount): ?>
                            <span class="badge badge-secondary <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->lowIssuesPerformanceCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                    </a>
                </li>

                <li class="<?php echo e((__('lang_dir') == 'rtl' ? 'border-left-lg' : 'border-right-lg')); ?> "></li>

                <li class="nav-item">
                    <a class="nav-link d-flex align-items-center font-weight-medium py-3 px-3" href="#security">
                        <span class="d-flex align-items-center"><?php echo $__env->make('icons.health-and-guard', ['class' => 'fill-current width-4 height-4 '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <span><?php echo e(__('Security')); ?></span>
                        <?php if($report->highIssuesSecurityCount): ?>
                            <span class="badge badge-danger <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->highIssuesSecurityCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                        <?php if($report->mediumIssuesSecurityCount): ?>
                            <span class="badge badge-warning <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->mediumIssuesSecurityCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                        <?php if($report->lowIssuesSecurityCount): ?>
                            <span class="badge badge-secondary <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->lowIssuesSecurityCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                    </a>
                </li>

                <li class="<?php echo e((__('lang_dir') == 'rtl' ? 'border-left-lg' : 'border-right-lg')); ?> "></li>

                <li class="nav-item <?php echo e(Route::currentRouteName() == 'stats.overview' ? 'active' : ''); ?>">
                    <a class="nav-link d-flex align-items-center font-weight-medium py-3 px-3" href="#miscellaneous">
                        <span class="d-flex align-items-center"><?php echo $__env->make('icons.category', ['class' => 'fill-current width-4 height-4 '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        <span><?php echo e(__('Miscellaneous')); ?></span>
                        <?php if($report->highIssuesMiscellaneousCount): ?>
                            <span class="badge badge-danger <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->highIssuesMiscellaneousCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                        <?php if($report->mediumIssuesMiscellaneousCount): ?>
                            <span class="badge badge-warning <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->mediumIssuesMiscellaneousCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                        <?php if($report->lowIssuesMiscellaneousCount): ?>
                            <span class="badge badge-secondary <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(number_format($report->lowIssuesMiscellaneousCount, 0, __('.'), __(','))); ?></span>
                        <?php endif; ?>
                    </a>
                </li>
            </ul>
        </div>
    </nav>
</div>

<div class="<?php if(auth()->guard()->check()): ?> scroll-margin-top-22 scroll-margin-top-lg-4 scroll-margin-top-xl-18 <?php else: ?> scroll-margin-top-22 scroll-margin-top-xl-36 <?php endif; ?>" id="overview">
    <div class="card border-0 shadow-sm overflow-hidden">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Overview')); ?></div></div>
                <div class="col-auto d-flex align-items-center">
                    <div class="d-none d-print-flex">
                        <?php echo e(__('Report generated on :date at :time (UTC :offset).', ['date' => \Carbon\Carbon::now()->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d')), 'time' => \Carbon\Carbon::now()->tz(Auth::user()->timezone ?? config('app.timezone'))->format('H:i:s'), 'offset' => \Carbon\CarbonTimeZone::create((Auth::user()->timezone ?? config('app.timezone')))->toOffsetName()])); ?>

                    </div>
                    <div class="d-print-none text-muted" data-tooltip="true" title="<?php echo e($report->generated_at->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d') . ' H:i:s')); ?>"><?php echo e($report->generated_at->tz(Auth::user()->timezone ?? config('app.timezone'))->diffForHumans()); ?></div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <?php if($errors->first('results')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e($errors->first('results')); ?>

                    <button type="button" class="close d-flex align-items-center justify-content-center width-12 height-12 p-0" data-dismiss="alert" aria-label="<?php echo e(__('Close')); ?>">
                        <span aria-hidden="true" class="d-flex align-items-center"><?php echo $__env->make('icons.close', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                    </button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-12 col-lg">
                    <div class="row">
                        <div class="col-12 col-lg-auto">
                            <div class="mx-auto mx-lg-0 position-relative d-flex align-items-center justify-content-center width-40 height-40 p-2">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 160 160" class="<?php echo e(($report->result > 79 ? 'stroke-success' : ($report->result > 49 ? 'stroke-warning' : 'stroke-danger'))); ?>" width="144" height="144">
                                    <circle cx="80" cy="80" r="75" stroke="#ddd" stroke-width="5" fill="transparent"/>

                                    <path d="M80,5A75,75,0,1,1,5,80,75,75,0,0,1,80,5" stroke-linecap="round" stroke-width="10" fill="transparent" stroke-dasharray="<?php echo e(number_format(($report->result / 100) * (2*3.14*75))); ?>,<?php echo e(number_format((2*3.14*75))); ?>"/>
                                </svg>
                                <div class="position-absolute">
                                    <div class="d-flex flex-column align-items-center">
                                        <div class="font-weight-bold h1 mb-0">
                                            <?php echo e(number_format($report->result)); ?>

                                        </div>

                                        <div class="text-muted border-top pt-1">
                                            100
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-lg text-center <?php echo e((__('lang_dir') == 'rtl' ? 'text-lg-right' : 'text-lg-left')); ?>">
                            <div class="my-2 h5"><?php echo e($report['results']['title']['value']); ?></div>
                            <div class="my-2 text-break text-muted"><?php echo e($report['results']['meta_description']['value']); ?></div>
                            <div class="my-2 text-break"><a href="<?php echo e($report['results']['seo_friendly_url']['value']); ?>" rel="nofollow" target="_blank"><?php echo e($report['results']['seo_friendly_url']['value']); ?></a></div>
                        </div>
                    </div>
                </div>

                <?php if(config('settings.ti')): ?>
                    <div class="col-12 col-lg-auto d-flex justify-content-center d-lg-block">
                        <img src="//image.thum.io/get<?php echo e(config('settings.ti_key') ? '/auth/' . config('settings.ti_key') : ''); ?>/width/504/crop/760/<?php echo e($report->fullUrl); ?>" width="252px" class="rounded mt-3 mt-lg-0">
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-footer">
            <div class="row">
                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="my-2">
                        <div class="d-flex justify-content-between mb-2 text-muted small">
                            <div class="d-flex text-truncate align-items-center">
                                <?php echo $__env->make('icons.triangle', ['class' => 'flex-shrink-0 width-3 height-3 fill-current ' . ($report->highIssuesCount > 0 ? 'text-danger ' : 'text-success ') . (__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate"><?php echo e(__(($report->highIssuesCount == 1 ? ':value high issue' : ':value high issues'), ['value' => number_format($report->highIssuesCount, 0, __('.'), __(','))])); ?></div>
                            </div>

                            <div class="d-flex align-items-baseline <?php echo e((__('lang_dir') == 'rtl' ? 'mr-3 text-left' : 'ml-3 text-right')); ?>">
                                <div class="width-12">
                                    <?php echo e(number_format((($report->highIssuesCount / $report->totalTestsCount) * 100), 1, __('.'), __(','))); ?>%
                                </div>
                            </div>
                        </div>

                        <div class="progress height-1.25 w-100">
                            <div class="progress-bar bg-danger rounded" role="progressbar" style="width: <?php echo e(number_format((($report->highIssuesCount / $report->totalTestsCount) * 100))); ?>%" aria-valuenow="<?php echo e(number_format((($report->highIssuesCount / $report->totalTestsCount) * 100))); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($report->totalTestsCount); ?>"></div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="my-2">
                        <div class="d-flex justify-content-between mb-2 text-muted small">
                            <div class="d-flex text-truncate align-items-center">
                                <?php echo $__env->make('icons.square', ['class' => 'flex-shrink-0 width-3 height-3 fill-current ' . ($report->mediumIssuesCount > 0 ? 'text-warning ' : 'text-success ') . (__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate"><?php echo e(__(($report->mediumIssuesCount == 1 ? ':value medium issue' : ':value medium issues'), ['value' => number_format($report->mediumIssuesCount, 0, __('.'), __(','))])); ?></div>
                            </div>

                            <div class="d-flex align-items-baseline <?php echo e((__('lang_dir') == 'rtl' ? 'mr-3 text-left' : 'ml-3 text-right')); ?>">
                                <div class="width-12">
                                    <?php echo e(number_format((($report->mediumIssuesCount / $report->totalTestsCount) * 100), 1, __('.'), __(','))); ?>%
                                </div>
                            </div>
                        </div>

                        <div class="progress height-1.25 w-100">
                            <div class="progress-bar bg-warning rounded" role="progressbar" style="width: <?php echo e(number_format((($report->mediumIssuesCount / $report->totalTestsCount) * 100))); ?>%" aria-valuenow="<?php echo e(number_format((($report->mediumIssuesCount / $report->totalTestsCount) * 100))); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($report->totalTestsCount); ?>"></div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="my-2">
                        <div class="d-flex justify-content-between mb-2 text-muted small">
                            <div class="d-flex text-truncate align-items-center">
                                <?php echo $__env->make('icons.circle', ['class' => 'flex-shrink-0 width-3 height-3 fill-current ' . ($report->lowIssuesCount > 0 ? 'text-secondary ' : 'text-success ') . (__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate"><?php echo e(__(($report->lowIssuesCount == 1 ? ':value low issue' : ':value low issues'), ['value' => number_format($report->lowIssuesCount, 0, __('.'), __(','))])); ?></div>
                            </div>

                            <div class="d-flex align-items-baseline <?php echo e((__('lang_dir') == 'rtl' ? 'mr-3 text-left' : 'ml-3 text-right')); ?>">
                                <div class="width-12">
                                    <?php echo e(number_format((($report->lowIssuesCount / $report->totalTestsCount) * 100), 1, __('.'), __(','))); ?>%
                                </div>
                            </div>
                        </div>

                        <div class="progress height-1.25 w-100">
                            <div class="progress-bar bg-secondary rounded" role="progressbar" style="width: <?php echo e(number_format((($report->lowIssuesCount / $report->totalTestsCount) * 100))); ?>%" aria-valuenow="<?php echo e(number_format((($report->lowIssuesCount / $report->totalTestsCount) * 100))); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($report->totalTestsCount); ?>"></div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="my-2">
                        <div class="d-flex justify-content-between mb-2 text-muted small">
                            <div class="d-flex text-truncate align-items-center">
                                <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 width-3 height-3 fill-current text-success ' . (__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate"><?php echo e(__(($report->nonIssuesCount == 1 ? ':value test passed' : ':value tests passed'), ['value' => $report->nonIssuesCount])); ?></div>
                            </div>

                            <div class="d-flex align-items-baseline <?php echo e((__('lang_dir') == 'rtl' ? 'mr-3 text-left' : 'ml-3 text-right')); ?>">
                                <div class="width-12">
                                    <?php echo e(number_format((($report->nonIssuesCount / $report->totalTestsCount) * 100), 1, __('.'), __(','))); ?>%
                                </div>
                            </div>
                        </div>

                        <div class="progress height-1.25 w-100">
                            <div class="progress-bar bg-success rounded" role="progressbar" style="width: <?php echo e(number_format((($report->nonIssuesCount / $report->totalTestsCount) * 100))); ?>%" aria-valuenow="<?php echo e(number_format((($report->nonIssuesCount / $report->totalTestsCount) * 100))); ?>" aria-valuemin="0" aria-valuemax="<?php echo e($report->totalTestsCount); ?>"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-footer">
            <div class="row">
                <div class="col-12 col-sm-6 col-lg-3 my-2 d-flex align-items-center">
                    <div class="d-flex position-relative text-secondary width-8 height-8 align-items-center justify-content-center flex-shrink-0">
                        <div class="position-absolute bg-secondary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-lg"></div>
                        <?php echo $__env->make('icons.timer', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="<?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Load time')); ?>">
                        <?php echo e(__(':value seconds', ['value' => number_format($report['results']['load_time']['value'], 2, __('.'), __(','))])); ?>

                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-3 my-2 d-flex align-items-center">
                    <div class="d-flex position-relative text-secondary width-8 height-8 align-items-center justify-content-center flex-shrink-0">
                        <div class="position-absolute bg-secondary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-lg"></div>
                        <?php echo $__env->make('icons.balance', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="<?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Page size')); ?>">
                        <?php echo e(formatBytes($report['results']['page_size']['value'], 2, __('.'), __(','))); ?>

                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-3 my-2 d-flex align-items-center">
                    <div class="d-flex position-relative text-secondary width-8 height-8 align-items-center justify-content-center flex-shrink-0">
                        <div class="position-absolute bg-secondary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-lg"></div>
                        <?php echo $__env->make('icons.device-hub', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="<?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('HTTP requests')); ?>">
                        <?php echo e(__((array_sum(array_map('count', $report['results']['http_requests']['value'])) == 1 ? ':value resource' : ':value resources'), ['value' => number_format(array_sum(array_map('count', $report['results']['http_requests']['value'])), 0, __('.'), __(','))])); ?>

                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-3 my-2 d-flex align-items-center">
                    <div class="d-flex position-relative text-secondary width-8 height-8 align-items-center justify-content-center flex-shrink-0">
                        <div class="position-absolute bg-secondary opacity-10 top-0 right-0 bottom-0 left-0 border-radius-lg"></div>
                        <?php echo $__env->make('icons.lock', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="<?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('HTTPS encryption')); ?>">
                        <?php if($report['results']['https_encryption']['passed']): ?>
                            <?php echo e(__('Secure')); ?>

                        <?php else: ?>
                            <?php echo e(__('Insecure')); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="<?php if(auth()->guard()->check()): ?> scroll-margin-top-22 scroll-margin-top-lg-4 scroll-margin-top-xl-18 <?php else: ?> scroll-margin-top-22 scroll-margin-top-xl-36 <?php endif; ?> mt-3" id="seo">
    <div class="card border-0 shadow-sm overflow-hidden">
        <div class="card-header align-items-center border-bottom-0">
            <div class="row">
                <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('SEO')); ?></div></div>
            </div>
        </div>

        <?php $__currentLoopData = $report->categories['seo']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make('reports.partials.' . str_replace('_', '-', $category), ['name' => $category], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<div class="<?php if(auth()->guard()->check()): ?> scroll-margin-top-22 scroll-margin-top-lg-4 scroll-margin-top-xl-18 <?php else: ?> scroll-margin-top-22 scroll-margin-top-xl-36 <?php endif; ?> mt-3" id="performance">
    <div class="card border-0 shadow-sm overflow-hidden">
        <div class="card-header align-items-center border-bottom-0">
            <div class="row">
                <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Performance')); ?></div></div>
            </div>
        </div>

        <?php $__currentLoopData = $report->categories['performance']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make('reports.partials.' . str_replace('_', '-', $category), ['name' => $category], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<div class="<?php if(auth()->guard()->check()): ?> scroll-margin-top-22 scroll-margin-top-lg-4 scroll-margin-top-xl-18 <?php else: ?> scroll-margin-top-22 scroll-margin-top-xl-36 <?php endif; ?> mt-3" id="security">
    <div class="card border-0 shadow-sm overflow-hidden">
        <div class="card-header align-items-center border-bottom-0">
            <div class="row">
                <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Security')); ?></div></div>
            </div>
        </div>

        <?php $__currentLoopData = $report->categories['security']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make('reports.partials.' . str_replace('_', '-', $category), ['name' => $category], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<div class="<?php if(auth()->guard()->check()): ?> scroll-margin-top-22 scroll-margin-top-lg-4 scroll-margin-top-xl-18 <?php else: ?> scroll-margin-top-22 scroll-margin-top-xl-36 <?php endif; ?> mt-3" id="miscellaneous">
    <div class="card border-0 shadow-sm overflow-hidden">
        <div class="card-header align-items-center border-bottom-0">
            <div class="row">
                <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Miscellaneous')); ?></div></div>
            </div>
        </div>

        <?php $__currentLoopData = $report->categories['miscellaneous']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make('reports.partials.' . str_replace('_', '-', $category), ['name' => $category], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<?php if(config('settings.ad_report_bottom')): ?>
    <div class="d-print-none mt-3"><?php echo config('settings.ad_report_bottom'); ?></div>
<?php endif; ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/show.blade.php ENDPATH**/ ?>