<?php $__env->startSection('site_title', formatTitle([__('QR generator'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 content-break"><?php echo e(__('QR generator')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('QR generator')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.qr_generator')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-content"><?php echo e(__('Content')); ?></label>
                <textarea name="content" id="i-content" class="form-control<?php echo e($errors->has('content') ? ' is-invalid' : ''); ?>"><?php echo e($content ?? (old('content') ?? '')); ?></textarea>
                <?php if($errors->has('content')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('content')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-size"><?php echo e(__('Size')); ?></label>
                <input type="number" name="size" id="i-size" class="form-control<?php echo e($errors->has('size') ? ' is-invalid' : ''); ?>" value="<?php echo e($size ?? (old('size') ?? '200')); ?>">
                <?php if($errors->has('size')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('size')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Generate')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.qr_generator')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('developerTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($result)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>
        <div class="card-body mb-n3">
            <div class="form-group">
                <label><?php echo e(__('QR code')); ?></label>

                <div id="qr-code">
                    <?php echo QrCode::encoding('UTF-8')->size($size)->margin(0)->generate($result); ?>

                </div>

                <button type="button" class="btn btn-primary mt-3" id="qr-download"><?php echo e(__('Download')); ?></button>

                <canvas id="qr-canvas" width="<?php echo e($size); ?>" height="<?php echo e($size); ?>" class="d-none"></canvas>
            </div>
        </div>
    </div>
<?php endif; ?>

<script>
    'use strict';

    let initiateDownload = (imgURI) => {
        var evt = new MouseEvent('click', {
            view: window,
            bubbles: false,
            cancelable: true
        });

        let a = document.createElement('a');
        a.setAttribute('download', 'qr.png');
        a.setAttribute('href', imgURI);
        a.setAttribute('target', '_blank');

        a.dispatchEvent(evt);
    }

    document.querySelector('#qr-download').addEventListener('click', function () {
        let canvas = document.querySelector('#qr-canvas');
        let ctx = canvas.getContext('2d');
        let data = (new XMLSerializer()).serializeToString(document.querySelector('#qr-code > svg'));
        let DOMURL = window.URL || window.webkitURL || window;

        let img = new Image();
        let svgBlob = new Blob([data], {type: 'image/svg+xml;charset=utf-8'});
        let url = DOMURL.createObjectURL(svgBlob);

        img.onload = function () {
            ctx.drawImage(img, 0, 0);
            DOMURL.revokeObjectURL(url);

            var imgURI = canvas.toDataURL('image/png').replace('image/png', 'image/octet-stream');

            initiateDownload(imgURI);
        };

        img.src = url;
    });
</script>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/qr-generator.blade.php ENDPATH**/ ?>