<?php $__env->startSection('site_title', formatTitle([__('SSL checker'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('SSL checker')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('SSL checker')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.ssl_checker')); ?>" method="post" enctype="multipart/form-data"  <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-domain"><?php echo e(__('Domain')); ?></label>
                <input type="text" dir="ltr" name="domain" id="i-domain" class="form-control<?php echo e($errors->has('domain') ? ' is-invalid' : ''); ?>" value="<?php echo e($domain ?? (old('domain') ?? '')); ?>">

                <?php if($errors->has('domain')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('domain')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Search')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.ssl_checker')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($result)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <?php if(empty($result)): ?>
                <?php echo e(__('No results found.')); ?>

            <?php else: ?>
                <div class="list-group list-group-flush my-n3">
                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-truncate text-muted"><?php echo e(__('Domain')); ?></div>
                            <div class="col-12 col-lg-8 text-truncate d-flex align-items-center">
                                <img src="https://icons.duckduckgo.com/ip3/<?php echo e($domain); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                <span dir="ltr"><?php echo e($domain); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-truncate text-muted"><?php echo e(__('Status')); ?></div>
                            <div class="col-12 col-lg-8 text-truncate d-flex align-items-center">
                                <?php if($result->isValid()): ?>
                                    <div class="bg-success width-4 height-4 rounded-circle <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>

                                    <div class="text-truncate"><?php echo e(__('Valid')); ?></div>
                                <?php else: ?>
                                    <div class="bg-danger width-4 height-4 rounded-circle <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>"></div>

                                    <div class="text-truncate"><?php echo e(__('Invalid')); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Issuer')); ?></div>
                            <div class="col-12 col-lg-8 text-break"><?php echo e($result->getIssuer()); ?></div>
                        </div>
                    </div>

                    <?php if(!empty($result->getOrganization())): ?>
                        <div class="list-group-item px-0">
                            <div class="row align-items-center">
                                <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Organization')); ?></div>
                                <div class="col-12 col-lg-8 text-break"><?php echo e($result->getOrganization()); ?></div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Signature algorithm')); ?></div>
                            <div class="col-12 col-lg-8 text-break"><?php echo e($result->getSignatureAlgorithm()); ?></div>
                        </div>
                    </div>

                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Issued date')); ?></div>
                            <div class="col-12 col-lg-8 text-break">
                                <?php echo e(__(':date at :time (UTC :offset)', ['date' => $result->validFromDate()->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d')), 'time' => $result->validFromDate()->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('H:i:s')), 'offset' => \Carbon\CarbonTimeZone::create((Auth::user()->timezone ?? config('app.timezone')))->toOffsetName()])); ?>

                            </div>
                        </div>
                    </div>

                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Expiration date')); ?></div>
                            <div class="col-12 col-lg-8 text-break">
                                <?php echo e(__(':date at :time (UTC :offset)', ['date' => $result->expirationDate()->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d')), 'time' => $result->expirationDate()->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('H:i:s')), 'offset' => \Carbon\CarbonTimeZone::create((Auth::user()->timezone ?? config('app.timezone')))->toOffsetName()])); ?>

                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/ssl-checker.blade.php ENDPATH**/ ?>