<?php $__env->startSection('site_title', formatTitle([__('Domain IP lookup'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('Domain IP lookup')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Domain IP lookup')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.domain_ip_lookup')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-domain"><?php echo e(__('Domain')); ?></label>
                <input type="text" dir="ltr" name="domain" id="i-domain" class="form-control<?php echo e($errors->has('domain') ? ' is-invalid' : ''); ?>" value="<?php echo e($domain ?? (old('domain') ?? '')); ?>">

                <?php if($errors->has('domain')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('domain')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Search')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.domain_ip_lookup')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('researchTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(!empty($result)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                </div>
            </div>
        </div>
        <div class="card-body mb-n3">
            <div class="row mx-n2">
                <div class="col-12 px-2">
                    <div class="form-group">
                        <label for="i-result-ip"><?php echo e(__('IP')); ?></label>
                        <div class="input-group">
                            <input id="i-result-ip" class="form-control" type="text" value="<?php echo e(__($result['traits']['ip_address'] ?? 'Unknown')); ?>" readonly>
                            <div class="input-group-append">
                                <div class="btn btn-primary" data-tooltip-copy="true" title="<?php echo e(__('Copy')); ?>" data-text-copy="<?php echo e(__('Copy')); ?>" data-text-copied="<?php echo e(__('Copied')); ?>" data-clipboard="true" data-clipboard-target="#i-result-ip"><?php echo e(__('Copy')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-md-4 px-2">
                    <div class="form-group">
                        <label for="i-result-country"><?php echo e(__('Country')); ?></label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <img src="<?php echo e(asset('/images/icons/countries/'. mb_strtolower($result['country']['iso_code'] ?? 'unknown'))); ?>.svg" class="width-4 height-4">
                                </div>
                            </div>
                            <input id="i-result-country" class="form-control" type="text" value="<?php echo e(__($result['country']['names']['en'] ?? 'Unknown')); ?>" readonly>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-md-4 px-2">
                    <div class="form-group">
                        <label for="i-result-city"><?php echo e(__('City')); ?></label>
                        <input id="i-result-city" class="form-control" type="text" value="<?php echo e(__($result['city']['names']['en'] ?? 'Unknown')); ?>" readonly>
                    </div>
                </div>

                <div class="col-12 col-md-4 px-2">
                    <div class="form-group">
                        <label for="i-result-postal-code"><?php echo e(__('Postal code')); ?></label>
                        <input id="i-result-postal-code" class="form-control" type="text" value="<?php echo e(__($result['postal']['code'] ?? 'Unknown')); ?>" readonly>
                    </div>
                </div>

                <div class="col-12 col-md-4 px-2">
                    <div class="form-group">
                        <label for="i-result-latitude"><?php echo e(__('Latitude')); ?></label>
                        <input id="i-result-latitude" class="form-control" type="text" value="<?php echo e(__($result['location']['latitude'] ?? 'Unknown')); ?>" readonly>
                    </div>
                </div>

                <div class="col-12 col-md-4 px-2">
                    <div class="form-group">
                        <label for="i-result-longitude"><?php echo e(__('Longtitude')); ?></label>
                        <input id="i-result-longitude" class="form-control" type="text" value="<?php echo e(__($result['location']['longitude'] ?? 'Unknown')); ?>" readonly>
                    </div>
                </div>

                <div class="col-12 col-md-4 px-2">
                    <div class="form-group">
                        <label for="i-result-timezone"><?php echo e(__('Timezone')); ?></label>
                        <input id="i-result-timezone" class="form-control" type="text" value="<?php echo e(__($result['location']['time_zone'] ?? 'Unknown')); ?>" readonly>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/domain-ip-lookup.blade.php ENDPATH**/ ?>