<?php $__env->startSection('site_title', formatTitle([__('Word density counter'), __('Tool'), config('settings.title')])); ?>

<?php $__env->startSection('head_content'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('tools'), 'title' => __('Tools')],
    ['title' => __('Tool')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <h1 class="h2 mb-3 text-break"><?php echo e(__('Word density counter')); ?></h1>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Word density counter')); ?></div>
            </div>
        </div>
    </div>
    <div class="card-body position-relative">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('tools.word_density_counter')); ?>" method="post" enctype="multipart/form-data" <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('contentTools', ['App\Models\User'])): ?> class="position-absolute left-5 right-5 opacity-20" <?php endif; ?>>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('contentTools', ['App\Models\User'])): ?>
                <div class="position-absolute top-0 right-0 bottom-0 left-0 z-1 more-gradient"></div>
            <?php endif; ?>

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-content"><?php echo e(__('Content')); ?></label>
                <textarea name="content" id="i-content" class="form-control<?php echo e($errors->has('content') ? ' is-invalid' : ''); ?>"><?php echo e($content ?? (old('content') ?? '')); ?></textarea>
                <?php if($errors->has('content')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('content')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col px-2">
                    <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Count')); ?></button>
                </div>
                <div class="col-auto px-2">
                    <a href="<?php echo e(route('tools.word_density_counter')); ?>" class="btn btn-outline-secondary ml-auto"><?php echo e(__('Reset')); ?></a>
                </div>
            </div>
        </form>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('contentTools', ['App\Models\User'])): ?>
            <?php if(paymentProcessors()): ?>
                <?php echo $__env->make('shared.features.locked', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('shared.features.unavailable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php if(isset($results)): ?>
    <div class="card border-0 shadow-sm mt-3">
        <div class="card-header align-items-center">
            <div class="row">
                <div class="col">
                    <div class="font-weight-medium py-1"><?php echo e(__('Results')); ?></div>
                </div>
            </div>
        </div>

        <div class="card-body">
            <?php if(empty($results)): ?>
                <?php echo e(__('No results found.')); ?>

            <?php else: ?>
                <div class="list-group list-group-flush my-n3">
                    <div class="list-group-item px-0 text-muted">
                        <div class="row">
                            <div class="col-12 col-lg-6 text-truncate">
                                <?php echo e(__('Keyword')); ?>

                            </div>

                            <div class="col-12 col-lg-3 text-truncate">
                                <?php echo e(__('Number')); ?>

                            </div>

                            <div class="col-12 col-lg-3 text-truncate">
                                <?php echo e(__('Density')); ?>

                            </div>
                        </div>
                    </div>

                    <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="list-group-item px-0">
                            <div class="row">
                                <div class="col-12 col-lg-6 text-truncate">
                                    <?php echo e($keyword); ?>

                                </div>

                                <div class="col-12 col-lg-3 text-truncate">
                                    <?php echo e($count); ?>

                                </div>

                                <div class="col-12 col-lg-3 text-truncate">
                                    <?php echo e(number_format((($count / $total) * 100), 2, __('.'), __(','))); ?>%
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>

<?php echo $__env->make('tools.related', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/tools/tool/word-density-counter.blade.php ENDPATH**/ ?>