@if(isset($report['results'][$name]))
    <div class="border-top">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12 col-lg-4">
                            <div class="d-flex align-items-center">
                                @include('reports.partials.status')

                                <div class="text-truncate font-weight-medium">{{ __('Deprecated HTML') }}</div>
                            </div>
                        </div>

                        <div class="col-12 col-lg-8">
                            @if($report['results'][$name]['passed'])
                                <div>
                                    {{ __('There are no deprecated HTML tags on the webpage.') }}
                                </div>
                            @else
                                @foreach($report['results'][$name]['errors'] as $error => $details)
                                    <div class="{{ (!$loop->first) ? 'mt-3' : ''}}">
                                        @if($error == 'bad_tags')
                                            {{ __('The webpage has deprecated HTML tags.') }}

                                            <div class="list-group mt-2">
                                                @foreach($details as $key => $value)
                                                    <div class="list-group-item p-0">
                                                        <div class="d-flex text-secondary justify-content-between align-items-center text-decoration-none px-3 py-2">
                                                            <div class="font-weight-medium"><code>&lt;{{ $key }}&gt;</code></div>
                                                            <span class="badge badge-secondary badge-pill">{{ number_format($value, 0, __('.'), __(',')) }}</span>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <div class="col-auto">
                    <a href="#collapse{{ $name }}" class="text-secondary" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse{{ $name }}" data-tooltip="true" title="{{ __('More') }}">
                        @include('icons.info', ['class' => 'fill-current width-4 height-4'])&#8203;
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="collapse{{ Auth::check() && Auth::user()->default_export_detailed ? ' d-print-block' : '' }}" id="collapse{{ $name }}">
        <div class="card-body pt-0">
            <div class="alert alert-secondary mb-0">
                {{ __('The deprecated tags represents the tags that are not supported HTML5 standard anymore, and could cause the webpage to be rendered incorrectly.') }}

                <hr>

                <div class="row">
                    <div class="col-12 col-md">
                        {{ __('Learn more') }}
                    </div>
                    <div class="col-12 col-md-auto">
                        <a href="https://dev.w3.org/html5/pf-summary/obsolete.html#non-conforming-features" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow">W3C @include('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')])</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif